/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.BinominalMapping;
import edu.udo.cs.yale.example.NominalAttribute;
import edu.udo.cs.yale.example.NominalMapping;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class BinominalAttribute
extends NominalAttribute {
    private NominalMapping nominalMapping = new BinominalMapping();

    BinominalAttribute(String name) {
        super(name, 8);
    }

    private BinominalAttribute(BinominalAttribute a) {
        super(a.getName(), 8);
        this.nominalMapping = (NominalMapping)a.nominalMapping.clone();
    }

    public Object clone() {
        return new BinominalAttribute(this);
    }

    public NominalMapping getMapping() {
        return this.nominalMapping;
    }

    public void setMapping(NominalMapping newMapping) {
        this.nominalMapping = newMapping;
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        super.writeAttributeData(out);
        out.writeInt(this.nominalMapping.size());
        Iterator<String> i = this.nominalMapping.getValues().iterator();
        while (i.hasNext()) {
            out.writeUTF(i.next());
        }
    }

    public void readAttributeData(DataInput in) throws IOException {
        super.readAttributeData(in);
        int num = in.readInt();
        int i = 0;
        while (i < num) {
            this.nominalMapping.mapString(in.readUTF());
            ++i;
        }
    }
}

