/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeight;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.gui.viewer.DataTableViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeights
extends AverageVector
implements Saveable {
    public static final int NO_SORTING = 0;
    public static final int DECREASING = -1;
    public static final int INCREASING = 1;
    private static final String[] SORTING_ORDER_NAMES = new String[]{"no sorting", "decreasing", "increasing"};
    public static final int ORIGINAL_WEIGHTS = 0;
    public static final int ABSOLUTE_WEIGHTS = 1;
    private static final String[] SORTING_TYPE_NAMES = new String[]{"original weights", "absolute weights"};
    private int sortType = 0;
    private int weightType = 0;
    private Map<String, AttributeWeight> weightMap = new LinkedHashMap<String, AttributeWeight>();

    public AttributeWeights() {
    }

    public AttributeWeights(ExampleSet exampleSet) {
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.setWeight(attribute.getName(), 1.0);
        }
    }

    private AttributeWeights(AttributeWeights weights) {
        for (String name : weights.getAttributeNames()) {
            this.setWeight(name, weights.getWeight(name));
        }
    }

    @Override
    public String getName() {
        return "AttributeWeights";
    }

    public void setWeight(String name, double weight) {
        AttributeWeight oldWeight = this.weightMap.get(name);
        if (Double.isNaN(weight)) {
            this.weightMap.remove(name);
            super.removeAveragable(oldWeight);
        } else if (oldWeight == null) {
            AttributeWeight attWeight = new AttributeWeight(this, name, weight);
            super.addAveragable(attWeight);
            this.weightMap.put(name, attWeight);
        } else {
            oldWeight.setWeight(weight);
        }
    }

    public double getWeight(String name) {
        AttributeWeight weight = this.weightMap.get(name);
        if (weight == null) {
            return Double.NaN;
        }
        return weight.getWeight();
    }

    public int getWeightType() {
        return this.weightType;
    }

    public int getSortingType() {
        return this.sortType;
    }

    @Override
    public int size() {
        return this.weightMap.size();
    }

    public Set<String> getAttributeNames() {
        return this.weightMap.keySet();
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AttributeWeights)) {
            return false;
        }
        AttributeWeights other = (AttributeWeights)o;
        return this.weightMap.equals(other.weightMap);
    }

    @Override
    public int hashCode() {
        return this.weightMap.hashCode();
    }

    public void sortByWeight(String[] attributeNames, int direction, int value) {
        Arrays.sort(attributeNames, new WeightComparator(direction, value));
    }

    @Override
    public void save(File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        out.println("<attributeweights version=\"" + Yale.getVersion() + "\">");
        for (String key : this.weightMap.keySet()) {
            double weight = this.weightMap.get(key).getWeight();
            out.println("    <weight name=\"" + key + "\" value=\"" + weight + "\"/>");
        }
        out.println("</attributeweights>");
        out.close();
    }

    public static AttributeWeights load(File file) throws IOException {
        AttributeWeights result = new AttributeWeights();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element attributeWeightsElement = document.getDocumentElement();
        if (!attributeWeightsElement.getTagName().equals("attributeweights")) {
            throw new IOException("Outer tag of attribute weights file must be <attributeweights>");
        }
        NodeList weights = attributeWeightsElement.getChildNodes();
        int i = 0;
        while (i < weights.getLength()) {
            Node node = weights.item(i);
            if (node instanceof Element) {
                Element weightTag = (Element)node;
                String tagName = weightTag.getTagName();
                if (!tagName.equals("weight")) {
                    throw new IOException("Only tags <weight> are allowed, was " + tagName);
                }
                String name = weightTag.getAttribute("name");
                String value = weightTag.getAttribute("value");
                double weight = 1.0;
                try {
                    weight = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Only numerical weights are allowed for the 'value' attribute.");
                }
                result.setWeight(name, weight);
            }
            ++i;
        }
        return result;
    }

    @Override
    public String getExtension() {
        return "wgt";
    }

    @Override
    public String getFileDescription() {
        return "attribute weights file";
    }

    @Override
    public String toString() {
        return "AttributeWeights (containing weights for " + this.weightMap.size() + " attributes)";
    }

    @Override
    public Object clone() {
        return new AttributeWeights(this);
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        DataTable dataTable = this.createSortedDataTable();
        final PlotterPanel plotterPanel = new PlotterPanel(dataTable, PlotterPanel.WEIGHT_PLOTTER_SELECTION);
        final DataTableViewer weightTableViewer = new DataTableViewer(dataTable);
        weightTableViewer.getTable().setAutoResizeMode(2);
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final JRadioButton weightTableButton = new JRadioButton("weight table", true);
        weightTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (weightTableButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)weightTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterPanel, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(weightTableButton);
        group.add(plotButton);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel settingsPanel = new JPanel(layout);
        mainPanel.add((Component)settingsPanel, "North");
        layout.setConstraints(weightTableButton, c);
        settingsPanel.add(weightTableButton);
        layout.setConstraints(plotButton, c);
        settingsPanel.add(plotButton);
        c.weightx = 1.0;
        JPanel filler = new JPanel();
        layout.setConstraints(filler, c);
        settingsPanel.add(filler);
        c.weightx = 0.0;
        final JComboBox<String> sortingDirectionBox = new JComboBox<String>(SORTING_ORDER_NAMES);
        sortingDirectionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = sortingDirectionBox.getSelectedIndex();
                switch (selectedIndex) {
                    case 0: {
                        AttributeWeights.this.sortType = 0;
                        break;
                    }
                    case 1: {
                        AttributeWeights.this.sortType = -1;
                        break;
                    }
                    case 2: {
                        AttributeWeights.this.sortType = 1;
                        break;
                    }
                    default: {
                        AttributeWeights.this.sortType = 0;
                    }
                }
                DataTable sortedDataTable = AttributeWeights.this.createSortedDataTable();
                weightTableViewer.setDataTable(sortedDataTable);
                plotterPanel.setDataTable(sortedDataTable);
            }
        });
        JLabel sortingLabel = new JLabel("sorting direction:");
        layout.setConstraints(sortingLabel, c);
        settingsPanel.add(sortingLabel);
        layout.setConstraints(sortingDirectionBox, c);
        settingsPanel.add(sortingDirectionBox);
        final JComboBox<String> sortingValueBox = new JComboBox<String>(SORTING_TYPE_NAMES);
        sortingValueBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = sortingValueBox.getSelectedIndex();
                switch (selectedIndex) {
                    case 0: {
                        AttributeWeights.this.weightType = 0;
                        break;
                    }
                    case 1: {
                        AttributeWeights.this.weightType = 1;
                        break;
                    }
                    default: {
                        AttributeWeights.this.weightType = 0;
                    }
                }
                DataTable sortedDataTable = AttributeWeights.this.createSortedDataTable();
                weightTableViewer.setDataTable(sortedDataTable);
                plotterPanel.setDataTable(sortedDataTable);
            }
        });
        JLabel valueTypeLabel = new JLabel("value type:");
        layout.setConstraints(valueTypeLabel, c);
        settingsPanel.add(valueTypeLabel);
        c.gridwidth = 0;
        layout.setConstraints(sortingValueBox, c);
        settingsPanel.add(sortingValueBox);
        mainPanel.add((Component)weightTableViewer, "Center");
        return mainPanel;
    }

    private DataTable createSortedDataTable() {
        SimpleDataTable dataTable = new SimpleDataTable("Attribute Weights", new String[]{"attribute", "weight"});
        Iterator<AttributeWeight> iter = this.getSortedWeights();
        while (iter.hasNext()) {
            AttributeWeight attWeight = iter.next();
            String attName = attWeight.getName();
            attWeight = this.weightMap.get(attName);
            double index = dataTable.mapString(0, attName);
            double weightValue = attWeight.getWeight();
            if (this.weightType == 1) {
                weightValue = Math.abs(weightValue);
            }
            double[] data = new double[]{index, weightValue};
            dataTable.add(new SimpleDataTableRow(data, attName));
        }
        return dataTable;
    }

    private Iterator<AttributeWeight> getSortedWeights() {
        LinkedList<AttributeWeight> allWeights = new LinkedList<AttributeWeight>();
        Iterator<String> i = this.weightMap.keySet().iterator();
        while (i.hasNext()) {
            AttributeWeight attWeight = new AttributeWeight(this.weightMap.get(i.next()));
            if (this.weightType == 1) {
                attWeight.setWeight(Math.abs(attWeight.getWeight()));
            }
            allWeights.add(attWeight);
        }
        if (this.sortType != 0) {
            Collections.sort(allWeights);
        }
        return allWeights.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeightComparator
    implements Comparator<String> {
        private int comparatorWeightType;
        private int direction;

        public WeightComparator(int direction, int comparatorWeightType) {
            this.comparatorWeightType = comparatorWeightType;
            this.direction = direction;
        }

        @Override
        public int compare(String o1, String o2) {
            double w1 = ((AttributeWeight)AttributeWeights.this.weightMap.get(o1)).getWeight();
            double w2 = ((AttributeWeight)AttributeWeights.this.weightMap.get(o2)).getWeight();
            if (this.comparatorWeightType == 1) {
                w1 = Math.abs(w1);
                w2 = Math.abs(w2);
            }
            return Double.compare(w2, w1) * this.direction;
        }
    }
}

