/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableExampleSetAdapter;
import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedAttributeRoles;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.AttributesExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeightedExampleSet
extends AbstractExampleSet {
    private AttributeWeights attributeWeights = new AttributeWeights();
    private boolean ignoreZeroWeightedAttributes = false;
    private ExampleSet parent;

    public AttributeWeightedExampleSet(ExampleSet exampleSet) {
        this(exampleSet, null);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights) {
        this(exampleSet, weights, 1.0);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights, double defaultWeight) {
        this.parent = exampleSet;
        if (weights == null) {
            this.attributeWeights = new AttributeWeights();
            for (Attribute attribute : this.getAttributes()) {
                this.attributeWeights.setWeight(attribute.getName(), defaultWeight);
            }
        } else {
            this.attributeWeights = weights;
            for (Attribute attribute : this.getAttributes()) {
                double weight = weights.getWeight(attribute.getName());
                this.attributeWeights.setWeight(attribute.getName(), Double.isNaN(weight) ? defaultWeight : weight);
            }
        }
    }

    public AttributeWeightedExampleSet(AttributeWeightedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.attributeWeights = (AttributeWeights)exampleSet.attributeWeights.clone();
        this.ignoreZeroWeightedAttributes = exampleSet.ignoreZeroWeightedAttributes;
    }

    public AttributeWeights getAttributeWeights() {
        return this.attributeWeights;
    }

    public AttributeWeightedExampleSet createCleanClone() {
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)this.clone();
        clone.setIgnoreZeroWeightedAttributes(true);
        return clone;
    }

    public void setIgnoreZeroWeightedAttributes(boolean ignoreZeroWeightedAttributes) {
        this.ignoreZeroWeightedAttributes = ignoreZeroWeightedAttributes;
    }

    @Override
    public Attributes getAttributes() {
        return new AttributeWeightedAttributeRoles(this.parent.getAttributes(), this, this.ignoreZeroWeightedAttributes);
    }

    public double getWeight(Attribute attribute) {
        double weight = this.attributeWeights.getWeight(attribute.getName());
        if (Double.isNaN(weight)) {
            throw new RuntimeException("Attribute " + attribute.getName() + " is not a regular attribute in this example set!");
        }
        return weight;
    }

    public void setWeight(Attribute attribute, double weightValue) {
        this.attributeWeights.setWeight(attribute.getName(), weightValue);
    }

    public int getNumberOfUsedAttributes() {
        int counter = 0;
        for (Attribute attribute : this.getAttributes()) {
            if (Tools.isEqual(this.getWeight(attribute), 0.0)) continue;
            ++counter;
        }
        return counter;
    }

    public void selectAll() {
        this.setAll(1.0);
    }

    public void deselectAll() {
        this.setAll(0.0);
    }

    private void setAll(double weight) {
        for (Attribute attribute : this.getAttributes()) {
            this.setWeight(attribute, weight);
        }
    }

    public boolean isAttributeUsed(Attribute attribute) {
        return this.getWeight(attribute) != 0.0;
    }

    public void setAttributeUsed(Attribute attribute, boolean selected) {
        this.setWeight(attribute, selected ? 1.0 : 0.0);
    }

    public void flipAttributeUsed(Attribute attribute) {
        this.setWeight(attribute, this.isAttributeUsed(attribute) ? 0.0 : 1.0);
    }

    public void selectRandomSubset(int n, Random random) {
        double ratio = (double)n / (double)this.getAttributes().size();
        for (Attribute attribute : this.getAttributes()) {
            if (random.nextDouble() < ratio) {
                this.setWeight(attribute, 1.0);
                continue;
            }
            this.setWeight(attribute, 0.0);
        }
        if (this.getNumberOfUsedAttributes() == 0) {
            double probDelta = 1.0 / (double)this.getAttributes().size();
            double prob = random.nextDouble();
            double currentMax = probDelta;
            for (Attribute attribute : this.getAttributes()) {
                if (prob < currentMax) {
                    this.setWeight(attribute, 1.0);
                    break;
                }
                currentMax += probDelta;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeWeightedExampleSet)) {
            return false;
        }
        return super.equals(o) && this.attributeWeights.equals(((AttributeWeightedExampleSet)o).attributeWeights);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.attributeWeights.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append(String.valueOf(Tools.getLineSeparator()) + "Weights: ");
        int i = 0;
        for (Attribute attribute : this.getAttributes()) {
            if (i != 0) {
                buffer.append(", ");
            }
            if (i > 50) {
                buffer.append("...");
                break;
            }
            buffer.append(String.valueOf(attribute.getName()) + ":" + this.getWeight(attribute));
            ++i;
        }
        return buffer.toString();
    }

    protected DataTable createDataTable(IOContainer container) {
        return new DataTableExampleSetAdapter(this, this.attributeWeights);
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return new Example(this.parent.getExample(index).getDataRow(), this);
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }
}

