/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeValueFilterSingleCondition;
import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import java.util.LinkedList;
import java.util.List;

public class AttributeValueFilter
implements Condition {
    private static final int AND = 0;
    private static final int OR = 1;
    private List<AttributeValueFilterSingleCondition> conditions = new LinkedList<AttributeValueFilterSingleCondition>();
    private int combinationMode = 0;

    public AttributeValueFilter(Attribute attribute, int comparisonType, String value) {
        this.addCondition(attribute, comparisonType, value);
    }

    public AttributeValueFilter(ExampleSet exampleSet, String parameterString) {
        if (parameterString == null || parameterString.length() == 0) {
            throw new IllegalArgumentException("Parameter string must not be empty!");
        }
        String[] splitted = parameterString.split("\\|\\|");
        if (splitted.length > 1) {
            String[] stringArray = splitted;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String condition = stringArray[n];
                condition = condition.trim();
                this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, condition));
                ++n;
            }
            this.combinationMode = 1;
        } else {
            splitted = parameterString.split("\\&\\&");
            if (splitted.length > 1) {
                String[] stringArray = splitted;
                int n = 0;
                int n3 = stringArray.length;
                while (n < n3) {
                    String condition = stringArray[n];
                    condition = condition.trim();
                    this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, condition));
                    ++n;
                }
                this.combinationMode = 0;
            } else {
                this.addCondition(new AttributeValueFilterSingleCondition(exampleSet, parameterString));
                this.combinationMode = 0;
            }
        }
    }

    private void addCondition(Attribute attribute, int comparisonType, String value) {
        this.addCondition(new AttributeValueFilterSingleCondition(attribute, comparisonType, value));
    }

    private void addCondition(AttributeValueFilterSingleCondition condition) {
        this.conditions.add(condition);
    }

    public Condition duplicate() {
        return this;
    }

    public String toString() {
        return this.conditions.toString();
    }

    public boolean conditionOk(Example e) {
        for (AttributeValueFilterSingleCondition condition : this.conditions) {
            if (this.combinationMode == 0) {
                if (condition.conditionOk(e)) continue;
                return false;
            }
            if (!condition.conditionOk(e)) continue;
            return true;
        }
        return this.combinationMode == 0;
    }
}

