/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.AttributesExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSelectionExampleSet
extends AbstractExampleSet {
    private ExampleSet parent;
    private Attributes attributes;

    public AttributeSelectionExampleSet(ExampleSet exampleSet, boolean[] selectionMask) {
        this.parent = exampleSet;
        this.attributes = (Attributes)exampleSet.getAttributes().clone();
        if (selectionMask != null) {
            if (selectionMask.length != exampleSet.getAttributes().size()) {
                throw new IllegalArgumentException("Length of the selection mask must be equal to the parent's number of attributes.");
            }
            int counter = 0;
            Iterator<Attribute> i = this.attributes.iterator();
            while (i.hasNext()) {
                if (!selectionMask[counter]) {
                    i.remove();
                }
                ++counter;
            }
        }
    }

    public AttributeSelectionExampleSet(AttributeSelectionExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.attributes = (Attributes)exampleSet.attributes.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeSelectionExampleSet)) {
            return false;
        }
        return this.attributes.equals(((AttributeSelectionExampleSet)o).attributes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.attributes.hashCode();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return new Example(this.parent.getExample(index).getDataRow(), this);
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }
}

