/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ConstructionDescription;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeParser {
    private Map<String, Attribute> allAttributes = new HashMap<String, Attribute>();
    private List<Attribute> newAttributes = new LinkedList<Attribute>();
    private ExampleTable exampleTable;

    public AttributeParser(ExampleTable et) {
        this.exampleTable = et;
        int i = 0;
        while (i < this.exampleTable.getNumberOfAttributes()) {
            Attribute a = this.exampleTable.getAttribute(i);
            if (a != null) {
                this.addAttribute(a);
            }
            ++i;
        }
    }

    public List getNewAttributes() {
        return this.newAttributes;
    }

    public void parseAll(InputStream in) throws IOException, GenerationException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element constructionsElement = document.getDocumentElement();
        if (!constructionsElement.getTagName().equals("constructions")) {
            throw new IOException("Outer tag of attribute constructions file must be <constructions>");
        }
        NodeList constructions = constructionsElement.getChildNodes();
        int i = 0;
        while (i < constructions.getLength()) {
            Node node = constructions.item(i);
            if (node instanceof Element) {
                Element constructionTag = (Element)node;
                String tagName = constructionTag.getTagName();
                if (!tagName.equals("attribute")) {
                    throw new IOException("Only tags <construction> are allowed, was " + tagName);
                }
                String attributeName = constructionTag.getAttribute("name");
                String attributeString = constructionTag.getAttribute("construction");
                Attribute att = this.parseAttribute(attributeString);
                if (attributeName != null) {
                    att.setName(attributeName);
                }
            }
            ++i;
        }
    }

    private Attribute addAttribute(Attribute a) {
        Attribute oldAtt = this.allAttributes.get(a.getConstruction().getDescription());
        if (oldAtt != null) {
            return oldAtt;
        }
        this.allAttributes.put(a.getConstruction().getDescription(), a);
        return a;
    }

    private static int getClosingBracketIndex(String string, int startIndex) throws GenerationException {
        int nextClosing;
        int openCount = 1;
        do {
            int nextOpen = string.indexOf("(", startIndex + 1);
            nextClosing = string.indexOf(")", startIndex + 1);
            if (nextClosing == -1) {
                throw new GenerationException("Malformed attribute description: mismatched parantheses");
            }
            if (nextOpen != -1 && nextOpen < nextClosing) {
                ++openCount;
                startIndex = nextOpen;
                continue;
            }
            --openCount;
            startIndex = nextClosing;
        } while (openCount != 0);
        return nextClosing;
    }

    public Attribute parseAttribute(String constructionDescription) throws GenerationException {
        Attribute[] attributes = this.parseAttributes(constructionDescription);
        if (attributes.length != 1) {
            throw new GenerationException("Malformed function description: too many attributes");
        }
        this.newAttributes.add(attributes[0]);
        return attributes[0];
    }

    private Attribute[] parseAttributes(String string) throws GenerationException {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int start = 0;
        while (start < string.length()) {
            Attribute attribute;
            String name;
            int end;
            int leftBr = string.indexOf("(", start);
            int comma = string.indexOf(",", start);
            if (comma == -1 && leftBr == -1) {
                end = string.length();
                name = string.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments!");
                }
                attribute = AttributeFactory.createAttribute(name, 2);
                attributes.add(this.addAttribute(attribute));
                start = string.length();
                continue;
            }
            if (leftBr == -1 || comma < leftBr && comma != -1) {
                end = comma;
                name = string.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments!");
                }
                attribute = AttributeFactory.createAttribute(name, 2);
                attributes.add(this.addAttribute(attribute));
                start = end + 1;
                continue;
            }
            int rightBr = AttributeParser.getClosingBracketIndex(string, leftBr);
            String functionName = string.substring(start, leftBr).trim();
            Attribute[] arguments = this.parseAttributes(string.substring(leftBr + 1, rightBr).trim());
            ConstructionDescription[] argumentDescriptions = new ConstructionDescription[arguments.length];
            int i = 0;
            while (i < argumentDescriptions.length) {
                argumentDescriptions[i] = arguments[i].getConstruction();
                ++i;
            }
            attributes.add(this.addAttribute(AttributeFactory.createAttribute(functionName, argumentDescriptions)));
            start = string.indexOf(",", rightBr) + 1;
            if (start > 0) continue;
            start = string.length();
        }
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        return attributeArray;
    }

    private Collection<FeatureGenerator> applicableGenerators() throws GenerationException {
        HashSet<FeatureGenerator> generators = new HashSet<FeatureGenerator>();
        Iterator<Attribute> i = this.allAttributes.values().iterator();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (FeatureGenerator.getAttributeInTable(this.exampleTable, a) == null) {
                FeatureGenerator fg;
                if (!this.argumentsAlreadyGenerated(a) || (fg = FeatureGenerator.createGeneratorForFunction(a.getConstruction().getFunction())) == null) continue;
                Attribute[] args = new Attribute[a.getConstruction().getArguments().length];
                int c = 0;
                while (c < args.length) {
                    args[c] = a.getConstruction().getArguments()[c].getAttribute();
                    ++c;
                }
                if (args != null) {
                    int n = 0;
                    while (n < args.length) {
                        args[n] = FeatureGenerator.getAttributeInTable(this.exampleTable, args[n]);
                        ++n;
                    }
                    if (fg.getInputAttributes().length != args.length) {
                        throw new GenerationException(fg + " has arity " + fg.getInputAttributes().length + "!");
                    }
                    fg.setArguments(args);
                }
                generators.add(fg);
                i.remove();
                continue;
            }
            i.remove();
        }
        return generators;
    }

    private boolean argumentsAlreadyGenerated(Attribute a) {
        ConstructionDescription[] arguments = a.getConstruction().getArguments();
        if (arguments == null) {
            return true;
        }
        int i = 0;
        while (i < arguments.length) {
            if (FeatureGenerator.getAttributeInTable(this.exampleTable, arguments[i].getAttribute()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void generateAll(ExampleSet exampleSet) throws GenerationException {
        Collection<FeatureGenerator> generators;
        LinkedList<Attribute> allGeneratedAttributes = new LinkedList<Attribute>();
        while ((generators = this.applicableGenerators()).size() > 0) {
            List<Attribute> generatedAtts = FeatureGenerator.generateAll(this.exampleTable, generators);
            allGeneratedAttributes.addAll(generatedAtts);
        }
        Iterator<Attribute> i = this.allAttributes.values().iterator();
        while (i.hasNext()) {
            LogService.logMessage("Could not generate attribute " + i.next(), 6);
        }
        if (this.allAttributes.size() > 0) {
            throw new GenerationException("Couldn't generate all attributes! Failing: " + this.allAttributes);
        }
        for (Attribute attribute : this.newAttributes) {
            Iterator k = allGeneratedAttributes.iterator();
            Attribute generatedAttribute = null;
            while (k.hasNext()) {
                Attribute currentAttribute = (Attribute)k.next();
                if (!currentAttribute.getConstruction().equals(attribute.getConstruction())) continue;
                generatedAttribute = currentAttribute;
                break;
            }
            if (generatedAttribute == null) continue;
            generatedAttribute.setName(attribute.getName());
            if (exampleSet.getAttributes().contains(generatedAttribute)) continue;
            exampleSet.getAttributes().addRegular(generatedAttribute);
        }
        allGeneratedAttributes.removeAll(this.newAttributes);
        LogService.logMessage("Removing " + allGeneratedAttributes.size() + " intermediate attributes.", 0);
        i = allGeneratedAttributes.iterator();
        while (i.hasNext()) {
            this.exampleTable.removeAttribute(i.next());
        }
    }
}

