/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.BinominalAttribute;
import edu.udo.cs.yale.example.ConstructionDescription;
import edu.udo.cs.yale.example.NumericalAttribute;
import edu.udo.cs.yale.example.PolynominalAttribute;
import edu.udo.cs.yale.tools.Ontology;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class AttributeFactory {
    private static final String GENSYM_PREFIX = "gensym";
    private static Map<String, AtomicInteger> nameCounters = new HashMap<String, AtomicInteger>();

    static {
        AttributeFactory.resetNameCounters();
    }

    public static Attribute createAttribute(String name, int valueType) {
        String attributeName;
        String string = attributeName = name != null ? name : AttributeFactory.createName();
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 8)) {
            return new BinominalAttribute(attributeName);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
            return new PolynominalAttribute(attributeName, valueType);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
            return new NumericalAttribute(attributeName, valueType);
        }
        throw new RuntimeException("AttributeFactory: cannot create attribute with value type '" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(valueType) + "' (" + valueType + ")!");
    }

    public static Attribute createAttribute(int valueType) {
        return AttributeFactory.createAttribute(AttributeFactory.createName(), valueType);
    }

    public static Attribute createAttribute(String functionName, ConstructionDescription[] arguments) {
        return AttributeFactory.createAttribute(2, 3, functionName, arguments);
    }

    public static Attribute createAttribute(int valueType, int blockType, String functionName, ConstructionDescription[] arguments) {
        Attribute attribute = AttributeFactory.createAttribute(valueType);
        attribute.setBlockType(blockType);
        attribute.getConstruction().setFunction(functionName);
        attribute.getConstruction().setArguments(arguments);
        return attribute;
    }

    public static Attribute createAttribute(String name, int valueType, int blockType) {
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        attribute.setBlockType(blockType);
        return attribute;
    }

    public static Attribute createAttribute(Attribute attribute) {
        return AttributeFactory.createAttribute(attribute, null);
    }

    public static Attribute createAttribute(Attribute attribute, String functionName) {
        Attribute result = (Attribute)attribute.clone();
        if (functionName == null) {
            result.setName(attribute.getName());
        } else {
            result.setName(String.valueOf(functionName) + "(" + attribute.getName() + ")");
            result.getConstruction().setFunction(functionName);
            result.getConstruction().setArguments(new ConstructionDescription[]{attribute.getConstruction()});
        }
        return result;
    }

    public static Attribute changeValueType(Attribute attribute, int valueType) {
        Attribute result = AttributeFactory.createAttribute(attribute.getName(), valueType);
        if (attribute.isNominal() && result.isNominal()) {
            result.setMapping(attribute.getMapping());
        }
        result.setTableIndex(attribute.getTableIndex());
        return result;
    }

    public static Attribute readAttribute(DataInput in) throws IOException {
        String name = in.readUTF();
        int valueType = in.readInt();
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        attribute.readAttributeData(in);
        return attribute;
    }

    public static void resetNameCounters() {
        nameCounters.clear();
    }

    public static String createName() {
        return AttributeFactory.createName(GENSYM_PREFIX);
    }

    public static String createName(String prefix) {
        AtomicInteger counter = nameCounters.get(prefix);
        if (counter == null) {
            nameCounters.put(prefix, new AtomicInteger(1));
            return prefix;
        }
        return String.valueOf(prefix) + counter.getAndIncrement();
    }
}

