/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.SparseDataRow;
import edu.udo.cs.yale.example.Tools;
import java.util.Arrays;

public abstract class AbstractSparseArrayDataRow
extends DataRow
implements SparseDataRow {
    private int[] x;
    private int counter = 0;

    public AbstractSparseArrayDataRow() {
        this(0);
    }

    public AbstractSparseArrayDataRow(int size) {
        this.x = new int[size];
        int i = 0;
        while (i < this.x.length) {
            this.x[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    protected abstract void removeValue(int var1);

    protected abstract void resizeValues(int var1);

    protected abstract void setValue(int var1, double var2);

    protected abstract double getValue(int var1);

    protected abstract void swapValues(int var1, int var2);

    protected abstract double[] getAllValues();

    private void sort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.x[j - 1] > this.x[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        long v = this.x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && (long)this.x[b] <= v) {
                if ((long)this.x[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (long)this.x[c] >= v) {
                if ((long)this.x[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort(n - s, s);
        }
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.x[a] < this.x[b] ? (this.x[b] < this.x[c] ? b : (this.x[a] < this.x[c] ? c : a)) : (this.x[b] > this.x[c] ? b : (this.x[a] > this.x[c] ? c : a));
    }

    protected void swap(int a, int b) {
        int t = this.x[a];
        this.x[a] = this.x[b];
        this.x[b] = t;
        this.swapValues(a, b);
    }

    double get(int val, double defaultValue) {
        int index = Arrays.binarySearch(this.x, val);
        if (index < 0) {
            return defaultValue;
        }
        return this.getValue(index);
    }

    void set(int index, double value, double defaultValue) {
        int index1 = Arrays.binarySearch(this.x, index);
        if (Tools.isDefault(defaultValue, value)) {
            if (index1 >= 0) {
                System.arraycopy(this.x, index1 + 1, this.x, index1, this.counter - (index1 + 1));
                this.x[this.counter - 1] = Integer.MAX_VALUE;
                this.removeValue(index1);
                --this.counter;
            }
        } else if (index1 < 0) {
            if (this.counter >= this.x.length) {
                int newlength = this.x.length + (this.x.length >> 1) + 1;
                int[] y = new int[newlength];
                System.arraycopy(this.x, 0, y, 0, this.x.length);
                int i = this.x.length;
                while (i < y.length) {
                    y[i] = Integer.MAX_VALUE;
                    ++i;
                }
                this.x = y;
                this.resizeValues(newlength);
            }
            this.x[this.counter] = index;
            this.setValue(this.counter, value);
            if (this.counter > 0 && index < this.x[this.counter - 1]) {
                this.sort(0, this.x.length);
            }
            ++this.counter;
        } else {
            this.setValue(index1, value);
        }
    }

    public int[] getNonDefaultIndices() {
        this.trim();
        return this.x;
    }

    public double[] getNonDefaultValues() {
        this.trim();
        return this.getAllValues();
    }

    public void ensureNumberOfColumns(int numberOfColumns) {
    }

    public void trim() {
        if (this.counter < this.x.length) {
            int[] y = new int[this.counter];
            System.arraycopy(this.x, 0, y, 0, this.counter);
            this.x = y;
            this.resizeValues(this.counter);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.x.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(String.valueOf(this.x[i]) + ":" + this.getValue(i));
            ++i;
        }
        result.append(", counter: " + this.counter);
        return result.toString();
    }
}

