/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableExampleSetAdapter;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.example.UnknownAttributeStatistics;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.viewer.DataViewer;
import edu.udo.cs.yale.gui.viewer.MetaDataViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleSet
extends ResultObjectAdapter
implements ExampleSet {
    @Override
    public String getName() {
        return "ExampleSet";
    }

    public String toString() {
        StringBuffer str = new StringBuffer(String.valueOf(Tools.classNameWOPackage(this.getClass())) + ":" + Tools.getLineSeparator());
        str.append(String.valueOf(this.size()) + " examples," + Tools.getLineSeparator());
        str.append(String.valueOf(this.getAttributes().size()) + " regular attributes," + Tools.getLineSeparator());
        boolean first = true;
        Iterator<AttributeRole> s = this.getAttributes().specialAttributes();
        while (s.hasNext()) {
            if (first) {
                str.append("special attributes = {" + Tools.getLineSeparator());
                first = false;
            }
            AttributeRole special = s.next();
            str.append("    " + special.getSpecialName() + " = " + special.getAttribute() + Tools.getLineSeparator());
        }
        if (!first) {
            str.append("}");
        } else {
            str.append("no special attributes" + Tools.getLineSeparator());
        }
        return str.toString();
    }

    private final DataTable createDataTable(IOContainer container) {
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : this.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException missingIOObjectException) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(this, weights);
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final MetaDataViewer metaDataViewer = new MetaDataViewer(this);
        final DataViewer dataViewer = new DataViewer(this);
        DataTable dataTable = this.createDataTable(container);
        final PlotterPanel plotterComponent = new PlotterPanel(dataTable);
        final JRadioButton metaDataButton = new JRadioButton("meta data view", true);
        metaDataButton.setToolTipText("Changes to a table showing information about all attributes.");
        metaDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (metaDataButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)metaDataViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton dataButton = new JRadioButton("data view", true);
        dataButton.setToolTipText("Changes to a table showing the complete example set.");
        dataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dataButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)dataViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.setToolTipText("Changes to a plot view of the example data.");
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(metaDataButton);
        group.add(dataButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(metaDataButton);
        togglePanel.add(dataButton);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add((Component)metaDataViewer, "Center");
        return mainPanel;
    }

    @Override
    public List<Action> getActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add(new AbstractAction("Save..."){
            private static final long serialVersionUID = 763183727596275786L;

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "In the following you can save both a data file and an attribute description file.", "Save data and meta data", 1);
                File dataFile = SwingTools.chooseFile(null, null, false, "dat", "example set data file");
                try {
                    if (dataFile != null) {
                        AbstractExampleSet.this.writeDataFile(dataFile, -1, false, false);
                        File attFile = SwingTools.chooseFile(null, dataFile, false, "aml", "attribute description file");
                        if (attFile != null) {
                            AbstractExampleSet.this.writeAttributeFile(attFile, dataFile);
                        }
                    }
                }
                catch (Exception ex) {
                    SwingTools.showErrorMessage("Cannot write example set to file '" + dataFile + "'", ex);
                }
            }
        });
        return result;
    }

    @Override
    public void writeDataFile(File dataFile, int fractionDigits, boolean zipped, boolean append) throws IOException {
        OutputStream outStream = null;
        outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
        PrintWriter out = new PrintWriter(outStream);
        Iterator reader = this.iterator();
        while (reader.hasNext()) {
            out.println(((Example)reader.next()).toDenseString(fractionDigits));
        }
        out.close();
        outStream.close();
    }

    @Override
    public void writeSparseDataFile(File dataFile, int format, int fractionDigits, boolean zipped, boolean append) throws IOException {
        OutputStream outStream = null;
        outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
        PrintWriter out = new PrintWriter(outStream);
        Iterator reader = this.iterator();
        while (reader.hasNext()) {
            out.println(((Example)reader.next()).toSparseString(format, fractionDigits));
        }
        out.close();
        outStream.close();
    }

    @Override
    public void writeAttributeFile(File attFile, File dataFile) throws IOException {
        if (dataFile == null) {
            throw new IOException("ExampleSet writing: cannot determine path to data file: data file was not given!");
        }
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        PrintWriter aout = new PrintWriter(new FileWriter(attFile));
        aout.println("<attributeset default_source=\"" + relativePath + "\">");
        int sourcecol = 1;
        for (Attribute attribute : this.getAttributes()) {
            AbstractExampleSet.writeAttributeData("attribute", attribute, sourcecol, aout, false);
            ++sourcecol;
        }
        aout.println("</attributeset>");
        aout.close();
    }

    @Override
    public void writeSparseAttributeFile(File attFile, File dataFile, int format) throws IOException {
        Attribute weightAttribute;
        Attribute idAttribute;
        if (dataFile == null) {
            throw new IOException("ExampleSet sparse writing: cannot determine path to data file: data file was not given!");
        }
        PrintWriter aout = new PrintWriter(new FileWriter(attFile));
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        aout.println("<attributeset default_source=\"" + relativePath + "\">");
        Attribute labelAttribute = this.getAttributes().getSpecial("label");
        if (labelAttribute != null && format != 4) {
            AbstractExampleSet.writeAttributeData("label", labelAttribute, 0, aout, true);
        }
        if ((idAttribute = this.getAttributes().getSpecial("id")) != null) {
            AbstractExampleSet.writeAttributeData("id", idAttribute, 0, aout, true);
        }
        if ((weightAttribute = this.getAttributes().getSpecial("weight")) != null) {
            AbstractExampleSet.writeAttributeData("weight", weightAttribute, 0, aout, true);
        }
        int sourcecol = 1;
        for (Attribute attribute : this.getAttributes()) {
            AbstractExampleSet.writeAttributeData("attribute", attribute, sourcecol, aout, true);
            ++sourcecol;
        }
        aout.println("</attributeset>");
        aout.close();
    }

    private static void writeAttributeData(String tag, Attribute attribute, int sourcecol, PrintWriter aout, boolean sparse) {
        aout.println("  <" + tag);
        aout.println("    name         = \"" + attribute.getName() + "\"");
        if (!sparse || tag.equals("attribute")) {
            aout.println("    sourcecol    = \"" + sourcecol + "\"");
        }
        aout.println("    valuetype    = \"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType()) + "\"");
        if (attribute.isNominal()) {
            aout.print("    classes      = \"");
            Iterator<String> i = attribute.getMapping().getValues().iterator();
            int n = 0;
            while (i.hasNext()) {
                if (n != 0) {
                    aout.print(" ");
                }
                ++n;
                String value = i.next();
                String quotedValue = Tools.escapeXML(value);
                aout.print(quotedValue);
            }
            aout.println("\"");
        }
        aout.println("    blocktype    = \"" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType()) + "\"");
        aout.println("  />");
    }

    @Override
    public String getExtension() {
        return "aml";
    }

    @Override
    public String getFileDescription() {
        return "attribute description file";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExampleSet)) {
            return false;
        }
        ExampleSet es = (ExampleSet)o;
        return this.getAttributes().equals(es.getAttributes());
    }

    @Override
    public int hashCode() {
        return this.getAttributes().hashCode();
    }

    @Override
    public IOObject copy() {
        return (IOObject)this.clone();
    }

    @Override
    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cloneConstructor = clazz.getConstructor(clazz);
            return cloneConstructor.newInstance(this);
        }
        catch (IllegalAccessException e) {
            LogService.logException("In AbstractExampleSet.clone():", null, e);
            throw new RuntimeException("Cannot clone ExampleSet: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LogService.logException("In AbstractExampleSet.clone():", null, e);
            throw new RuntimeException("'" + this.getClass().getName() + "' does not implement clone constructor!");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e + ". Target: " + e.getCause() + ". Cause: " + e.getTargetException() + ".");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e);
        }
    }

    @Override
    public void recalculateAllAttributeStatistics() {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> a = this.getAttributes().allAttributes();
        while (a.hasNext()) {
            allAttributes.add(a.next());
        }
        this.recalculateAttributeStatistics(allAttributes);
    }

    @Override
    public void recalculateAttributeStatistics(Attribute attribute) {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        allAttributes.add(attribute);
        this.recalculateAttributeStatistics(allAttributes);
    }

    public void recalculateAttributeStatistics(List<Attribute> attributeList) {
        UnknownAttributeStatistics[] attributeStats = new UnknownAttributeStatistics[attributeList.size()];
        int counter = 0;
        for (Attribute attribute : attributeList) {
            attributeStats[counter] = attribute.isNominal() ? new NominalAttributeStatistics(attribute) : new NumericalAttributeStatistics();
            ++counter;
        }
        Iterator reader = this.iterator();
        Example example = null;
        while ((example = (Example)reader.next()) != null) {
            counter = 0;
            for (Attribute attribute : attributeList) {
                UnknownAttributeStatistics stats = attributeStats[counter++];
                double value = example.getValue(attribute);
                if (Double.isNaN(value)) {
                    stats.addUnknown();
                    continue;
                }
                if (attribute.isNominal()) {
                    ((NominalAttributeStatistics)stats).addHit((int)value);
                    continue;
                }
                ((NumericalAttributeStatistics)stats).addValue(value);
            }
        }
        counter = 0;
        for (Attribute attribute : attributeList) {
            attribute.setStatistics(attributeStats[counter++]);
        }
    }
}

