/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeIterator;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.AttributeRoleIterator;
import edu.udo.cs.yale.example.Attributes;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributes
implements Attributes {
    @Override
    public abstract Object clone();

    @Override
    public Iterator<Attribute> iterator() {
        return new AttributeIterator(this.allAttributeRoles(), 0);
    }

    @Override
    public Iterator<Attribute> allAttributes() {
        return new AttributeIterator(this.allAttributeRoles(), 2);
    }

    @Override
    public Iterator<AttributeRole> specialAttributes() {
        return new AttributeRoleIterator(this.allAttributeRoles(), 1);
    }

    @Override
    public boolean contains(Attribute attribute) {
        return this.findAttributeRole(attribute.getName(), this.allAttributeRoles()) != null;
    }

    @Override
    public int allSize() {
        return this.calculateSize(this.allAttributes());
    }

    @Override
    public int size() {
        return this.calculateSize(this.iterator());
    }

    @Override
    public int specialSize() {
        return this.calculateSize(this.specialAttributes());
    }

    private int calculateSize(Iterator i) {
        int counter = 0;
        while (i.hasNext()) {
            i.next();
            ++counter;
        }
        return counter;
    }

    @Override
    public void addRegular(Attribute attribute) {
        this.add(new AttributeRole(attribute));
    }

    @Override
    public boolean remove(Attribute attribute) {
        return this.remove(this.getRole(attribute));
    }

    @Override
    public void clearRegular() {
        Iterator<Attribute> i = this.iterator();
        while (i.hasNext()) {
            i.remove();
        }
    }

    @Override
    public Attribute replace(Attribute first, Attribute second) {
        AttributeRole role = this.getRole(first);
        if (role == null) {
            throw new NoSuchElementException("Attribute " + first + " cannot be replaced by attribute " + second + ": " + first + " is not part of the example set!");
        }
        role.setAttribute(second);
        return second;
    }

    @Override
    public Attribute get(String name) {
        Attribute result = this.findAttribute(name, this.allAttributes());
        if (result == null) {
            result = this.getSpecial(name);
        }
        return result;
    }

    @Override
    public Attribute getRegular(String name) {
        return this.findAttribute(name, this.iterator());
    }

    @Override
    public Attribute getSpecial(String name) {
        AttributeRole role = this.findAttributeRole(name, this.specialAttributes());
        if (role == null) {
            return null;
        }
        return role.getAttribute();
    }

    private Attribute findAttribute(String name, Iterator<Attribute> i) {
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    private AttributeRole findAttributeRole(String name, Iterator<AttributeRole> i) {
        while (i.hasNext()) {
            AttributeRole role = i.next();
            if (!role.getAttribute().getName().equalsIgnoreCase(name) && (role.getSpecialName() == null || !role.getSpecialName().equalsIgnoreCase(name))) continue;
            return role;
        }
        return null;
    }

    @Override
    public AttributeRole getRole(Attribute attribute) {
        return this.getRole(attribute.getName());
    }

    @Override
    public AttributeRole getRole(String name) {
        return this.findAttributeRole(name, this.allAttributeRoles());
    }

    @Override
    public Attribute getLabel() {
        return this.getSpecial("label");
    }

    @Override
    public void setLabel(Attribute label) {
        this.setSpecialAttribute(label, "label");
    }

    @Override
    public Attribute getPredictedLabel() {
        return this.getSpecial("prediction");
    }

    @Override
    public void setPredictedLabel(Attribute predictedLabel) {
        this.setSpecialAttribute(predictedLabel, "prediction");
    }

    @Override
    public Attribute getId() {
        return this.getSpecial("id");
    }

    @Override
    public void setId(Attribute id) {
        this.setSpecialAttribute(id, "id");
    }

    @Override
    public Attribute getWeight() {
        return this.getSpecial("weight");
    }

    @Override
    public void setWeight(Attribute weight) {
        this.setSpecialAttribute(weight, "weight");
    }

    @Override
    public Attribute getCluster() {
        return this.getSpecial("cluster");
    }

    @Override
    public void setCluster(Attribute cluster) {
        this.setSpecialAttribute(cluster, "cluster");
    }

    @Override
    public Attribute getOutlier() {
        return this.getSpecial("outlier");
    }

    @Override
    public void setOutlier(Attribute outlier) {
        this.setSpecialAttribute(outlier, "outlier");
    }

    @Override
    public void setSpecialAttribute(Attribute attribute, String specialName) {
        AttributeRole oldRole = this.getRole(specialName);
        if (oldRole != null) {
            this.remove(oldRole);
        }
        if (attribute != null) {
            this.remove(attribute);
            AttributeRole role = new AttributeRole(attribute);
            role.setSpecial(specialName);
            this.add(role);
        }
    }

    @Override
    public Attribute[] createRegularAttributeArray() {
        int index = 0;
        Attribute[] result = new Attribute[this.size()];
        for (Attribute attribute : this) {
            result[index++] = attribute;
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator<AttributeRole> r = this.allAttributeRoles();
        boolean first = true;
        while (r.hasNext()) {
            if (!first) {
                result.append(", ");
            }
            result.append(r.next());
            first = false;
        }
        return result.toString();
    }
}

