/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeStatistics;
import edu.udo.cs.yale.example.ConstructionDescription;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.tools.Ontology;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractAttribute
implements Attribute {
    private String name;
    private int valueType = 0;
    private int blockType = 0;
    private int index = -1;
    private double defaultValue = 0.0;
    private AttributeStatistics attributeStatistics = null;
    private ConstructionDescription constructionDescription;

    AbstractAttribute(String name, int valueType) {
        this(name, valueType, 3);
    }

    AbstractAttribute(String name, int valueType, int blockType) {
        this.name = name;
        this.valueType = valueType;
        this.blockType = blockType;
        this.index = -1;
        this.constructionDescription = new ConstructionDescription(this, this.name);
    }

    public abstract Object clone();

    public boolean equals(Object o) {
        if (!(o instanceof AbstractAttribute)) {
            return false;
        }
        AbstractAttribute a = (AbstractAttribute)o;
        if (!this.name.equals(a.getName())) {
            return false;
        }
        return this.index == a.getTableIndex();
    }

    public int hashCode() {
        return this.name.hashCode() ^ Integer.valueOf(this.index).hashCode();
    }

    public double getValue(DataRow row) {
        return row.get(this.getTableIndex(), this.getDefault());
    }

    public void setValue(DataRow row, double value) {
        row.set(this.getTableIndex(), value, this.getDefault());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public int getTableIndex() {
        return this.index;
    }

    public void setTableIndex(int i) {
        this.index = i;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public void setBlockType(int b) {
        this.blockType = b;
    }

    public int getValueType() {
        return this.valueType;
    }

    public AttributeStatistics getStatistics() {
        return this.attributeStatistics;
    }

    public void setStatistics(AttributeStatistics statistics) {
        this.attributeStatistics = statistics;
    }

    public ConstructionDescription getConstruction() {
        return this.constructionDescription;
    }

    public void setDefault(double value) {
        this.defaultValue = value;
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("#");
        result.append(this.index);
        result.append(": ");
        result.append(this.name);
        result.append(" (");
        result.append(Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.valueType));
        result.append("/");
        result.append(Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.blockType));
        result.append(")");
        return result.toString();
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.valueType);
        out.writeInt(this.blockType);
    }

    public void readAttributeData(DataInput in) throws IOException {
        this.setBlockType(in.readInt());
    }
}

