/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.doc;

import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import edu.udo.cs.yale.doc.LatexOperatorDocGenerator;
import edu.udo.cs.yale.doc.OperatorDocGenerator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.GroupTree;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationGenerator {
    private OperatorDocGenerator generator;
    private static RootDoc rootDoc = null;

    public DocumentationGenerator(OperatorDocGenerator generator) {
        this.generator = generator;
    }

    private void getRootDoc() {
        this.getRootDoc(new File(ParameterService.getYaleHome(), "src" + File.separator), "edu.udo.cs.yale.operator");
    }

    private void getRootDoc(File srcDir, String subpackages) {
        LogService.logMessage("Starting javadoc!", 2);
        String[] javadocargs = new String[]{"-sourcepath", srcDir.getAbsolutePath(), "-doclet", this.getClass().getName(), "-breakiterator", "-subpackages", subpackages};
        Main.execute((String[])javadocargs);
        if (rootDoc == null) {
            LogService.logMessage("RootDoc not set!", 6);
        }
    }

    public static boolean start(RootDoc rootDoc) {
        LogService.logMessage("RootDoc generated!", 2);
        DocumentationGenerator.rootDoc = rootDoc;
        return true;
    }

    public void generateAll(PrintWriter out) {
        this.generateAll(out, false);
    }

    public void generateAll(PrintWriter out, boolean generateSubgroups) {
        GroupTree root = OperatorService.getGroups();
        if (root.getOperatorDescriptions().size() > 0) {
            this.generator.beginGroup(null, out);
            this.generateOperators(out, root.getOperatorDescriptions());
            this.generator.endGroup(null, out);
        }
        Collection<GroupTree> groups = root.getSubGroups();
        for (GroupTree group : groups) {
            this.generateGroup(out, group, generateSubgroups);
        }
        out.println();
        out.flush();
    }

    public void generateGroup(PrintWriter out, GroupTree group, boolean generateSubgroups) {
        this.generator.beginGroup(group.getName(), out);
        if (generateSubgroups) {
            this.generateOperators(out, group.getOperatorDescriptions());
            Collection<GroupTree> groups = group.getSubGroups();
            for (GroupTree subgroup : groups) {
                this.generateGroup(out, subgroup, generateSubgroups);
            }
        } else {
            this.generateOperators(out, group.getAllOperatorDescriptions());
        }
        this.generator.endGroup(group.getName(), out);
    }

    public void generateOperators(PrintWriter out, Collection<OperatorDescription> operators) {
        for (OperatorDescription description : operators) {
            try {
                Operator operator = description.createOperatorInstance();
                this.generator.generateDoc(operator, rootDoc, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
                System.err.println("Error in " + description.getName() + ": " + e.getMessage());
            }
        }
        out.println();
    }

    public static void main(String[] argv) throws IOException {
        LatexOperatorDocGenerator opDocGen = new LatexOperatorDocGenerator();
        if (argv.length == 0) {
            ParameterService.init();
            File file = new File(ParameterService.getYaleHome(), "tutorial" + File.separator + "OperatorsGenerated.tex");
            LogService.logMessage("Generating class documentation to '" + file + "'.", 2);
            DocumentationGenerator docGen = new DocumentationGenerator(opDocGen);
            docGen.getRootDoc();
            docGen.generateAll(new PrintWriter(new FileWriter(file)));
        } else if (argv.length >= 4) {
            try {
                OperatorService.registerOperators(argv[0], new FileInputStream(argv[0]), null, true);
            }
            catch (IOException e) {
                LogService.logMessage("Cannot read 'operators.xml'.", 6);
            }
            File file = new File(argv[3]);
            LogService.logMessage("Generating class documentation to '" + file + "'.", 2);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            DocumentationGenerator docGen = new DocumentationGenerator(opDocGen);
            boolean generateSubgroups = false;
            if (argv.length == 5 && argv[4].equals("true")) {
                generateSubgroups = true;
            }
            docGen.getRootDoc(new File(argv[1]), argv[2]);
            docGen.generateAll(new PrintWriter(new FileWriter(file)), generateSubgroups);
            out.close();
        } else {
            LogService.logMessage("usage: java edu.udo.cs.yale.doc.DocumentationGenerator or" + Tools.getLineSeparator() + "       java edu.udo.cs.yale.doc.DocumentationGenerator operatordesc srcdir subpackages outputfile [generate subgroups (true/false)]", 4);
        }
    }
}

