/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.AbstractDataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataTable
extends AbstractDataTable {
    private List<DataTableRow> data = new ArrayList<DataTableRow>();
    private String name;
    private String[] columns;
    private double[] weights;
    private boolean[] specialColumns;
    private Map<Integer, Map<Integer, String>> index2StringMap = new HashMap<Integer, Map<Integer, String>>();
    private Map<Integer, Map<String, Integer>> string2IndexMap = new HashMap<Integer, Map<String, Integer>>();

    public SimpleDataTable(String name, String[] columns) {
        this(name, columns, null);
    }

    public SimpleDataTable(String name, String[] columns, double[] weights) {
        this.name = name;
        this.columns = columns;
        this.weights = weights;
        this.specialColumns = new boolean[columns.length];
        int i = 0;
        while (i < this.specialColumns.length) {
            this.specialColumns[i] = false;
            ++i;
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        int counter = 0;
        boolean[] blArray = this.specialColumns;
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            boolean b = blArray[n];
            if (b) {
                ++counter;
            }
            ++n;
        }
        return counter;
    }

    @Override
    public boolean isSpecial(int index) {
        return this.specialColumns[index];
    }

    public void setSpecial(int index, boolean special) {
        this.specialColumns[index] = special;
    }

    @Override
    public boolean isNominal(int column) {
        return this.index2StringMap.get(column) != null;
    }

    @Override
    public String mapIndex(int column, int index) {
        Map<Integer, String> columnIndexMap = this.index2StringMap.get(column);
        return columnIndexMap.get(index);
    }

    @Override
    public int mapString(int column, String value) {
        Map<String, Integer> columnValueMap = this.string2IndexMap.get(column);
        if (columnValueMap == null) {
            columnValueMap = new HashMap<String, Integer>();
            columnValueMap.put(value, 0);
            this.string2IndexMap.put(column, columnValueMap);
            HashMap<Integer, String> columnIndexMap = new HashMap<Integer, String>();
            columnIndexMap.put(0, value);
            this.index2StringMap.put(column, columnIndexMap);
            return 0;
        }
        Integer result = columnValueMap.get(value);
        if (result != null) {
            return result;
        }
        int newIndex = columnValueMap.size();
        columnValueMap.put(value, newIndex);
        Map<Integer, String> columnIndexMap = this.index2StringMap.get(column);
        columnIndexMap.put(newIndex, value);
        return newIndex;
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.index2StringMap.get(column).size();
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return this.weights != null;
    }

    @Override
    public double getColumnWeight(int column) {
        if (this.weights == null) {
            return Double.NaN;
        }
        return this.weights[column];
    }

    @Override
    public String getColumnName(int i) {
        return this.columns[i];
    }

    @Override
    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.length;
    }

    @Override
    public String[] getColumnNames() {
        return this.columns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(DataTableRow row) {
        List<DataTableRow> list = this.data;
        synchronized (list) {
            this.data.add(row);
            this.fireEvent();
        }
    }

    @Override
    public DataTableRow getRow(int index) {
        return this.data.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator<DataTableRow> iterator() {
        Iterator<DataTableRow> i = null;
        List<DataTableRow> list = this.data;
        synchronized (list) {
            i = this.data.iterator();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfRows() {
        int result = 0;
        List<DataTableRow> list = this.data;
        synchronized (list) {
            result = this.data.size();
        }
        return result;
    }

    public void clear() {
        this.data.clear();
        this.fireEvent();
    }

    @Override
    public synchronized void sample(int newSize) {
        Random random = new Random();
        while (this.getNumberOfRows() > newSize) {
            int index = random.nextInt(this.getNumberOfRows());
            this.data.remove(index);
        }
    }
}

