/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.datatable.PairwiseCorrelation2DataTableRowWrapper;
import edu.udo.cs.yale.operator.visualization.CorrelationMatrix;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairwiseCorrelation2DataTableRowIterator
implements Iterator<DataTableRow> {
    private CorrelationMatrix matrix;
    private int firstAttribute;
    private int secondAttribute;

    public PairwiseCorrelation2DataTableRowIterator(CorrelationMatrix matrix) {
        this.matrix = matrix;
        this.firstAttribute = 0;
        this.secondAttribute = 1;
    }

    @Override
    public boolean hasNext() {
        return this.firstAttribute < this.matrix.getNumberOfColumns() && this.secondAttribute < this.matrix.getNumberOfColumns();
    }

    @Override
    public DataTableRow next() {
        PairwiseCorrelation2DataTableRowWrapper row = new PairwiseCorrelation2DataTableRowWrapper(this.matrix, this.firstAttribute, this.secondAttribute);
        ++this.secondAttribute;
        if (this.secondAttribute >= this.matrix.getNumberOfColumns()) {
            ++this.firstAttribute;
            this.secondAttribute = this.firstAttribute + 1;
        }
        return row;
    }

    @Override
    public void remove() {
        throw new RuntimeException("PairwiseCorrelation2DataTableRowIterator: removing rows is not supported!");
    }
}

