/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.AbstractDataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.datatable.PairwiseCorrelation2DataTableRowIterator;
import edu.udo.cs.yale.datatable.PairwiseCorrelation2DataTableRowWrapper;
import edu.udo.cs.yale.operator.visualization.CorrelationMatrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTablePairwiseCorrelationAdapter
extends AbstractDataTable {
    private static final String FIRST_COLUMN_NAME = "First Attribute";
    private static final String SECOND_COLUMN_NAME = "Second Attribute";
    private static final String CORRELATION_COLUMN_NAME = "Correlation";
    private CorrelationMatrix matrix;
    private String[] index2NameMap;
    private Map<String, Integer> name2IndexMap = new HashMap<String, Integer>();

    public DataTablePairwiseCorrelationAdapter(CorrelationMatrix matrix, String[] columnNames) {
        this.matrix = matrix;
        this.index2NameMap = columnNames;
        int i = 0;
        while (i < this.index2NameMap.length) {
            this.name2IndexMap.put(this.index2NameMap[i], i);
            ++i;
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 0;
    }

    @Override
    public boolean isSpecial(int index) {
        return false;
    }

    @Override
    public boolean isNominal(int index) {
        return index <= 1;
    }

    @Override
    public String mapIndex(int column, int value) {
        return this.index2NameMap[value];
    }

    @Override
    public int mapString(int column, String value) {
        Integer result = this.name2IndexMap.get(value);
        if (result == null) {
            return -1;
        }
        return result;
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.index2NameMap.length;
    }

    @Override
    public String getColumnName(int i) {
        switch (i) {
            case 0: {
                return FIRST_COLUMN_NAME;
            }
            case 1: {
                return SECOND_COLUMN_NAME;
            }
            case 2: {
                return CORRELATION_COLUMN_NAME;
            }
        }
        return "unknown";
    }

    @Override
    public int getColumnIndex(String name) {
        if (FIRST_COLUMN_NAME.equals(name)) {
            return 0;
        }
        if (SECOND_COLUMN_NAME.equals(name)) {
            return 1;
        }
        if (CORRELATION_COLUMN_NAME.equals(name)) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public double getColumnWeight(int column) {
        return Double.NaN;
    }

    @Override
    public int getNumberOfColumns() {
        return 3;
    }

    @Override
    public String getName() {
        return "Pairwise Correlation Table";
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTablePairwiseCorrelationMatrixAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int rowIndex) {
        int firstAttribute = 0;
        int secondAttribute = 1;
        int i = 0;
        while (i < rowIndex) {
            if (++secondAttribute >= this.matrix.getNumberOfColumns()) {
                secondAttribute = ++firstAttribute + 1;
            }
            ++i;
        }
        return new PairwiseCorrelation2DataTableRowWrapper(this.matrix, firstAttribute, secondAttribute);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new PairwiseCorrelation2DataTableRowIterator(this.matrix);
    }

    @Override
    public int getNumberOfRows() {
        return (this.index2NameMap.length * this.index2NameMap.length - this.index2NameMap.length) / 2;
    }

    @Override
    public void sample(int newSize) {
    }
}

