/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.AbstractDataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.datatable.KernelModelRow2DataTableRowWrapper;
import edu.udo.cs.yale.operator.learner.kernel.KernelModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableKernelModelAdapter
extends AbstractDataTable {
    private KernelModel kernelModel;
    private int[] sampleMapping = null;
    private Map<Integer, String> index2LabelMap = new HashMap<Integer, String>();
    private Map<String, Integer> label2IndexMap = new HashMap<String, Integer>();

    public DataTableKernelModelAdapter(KernelModel kernelModel) {
        this.kernelModel = kernelModel;
        int labelCounter = 0;
        if (this.kernelModel.isClassificationModel()) {
            int i = 0;
            while (i < this.kernelModel.getNumberOfExamples()) {
                String label = this.kernelModel.getClassificationLabel(i);
                if (this.label2IndexMap.get(label) == null) {
                    this.label2IndexMap.put(label, labelCounter);
                    this.index2LabelMap.put(labelCounter, label);
                    ++labelCounter;
                }
                ++i;
            }
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 6;
    }

    @Override
    public boolean isSpecial(int index) {
        return index < 6;
    }

    @Override
    public boolean isNominal(int index) {
        if (index == 1) {
            return this.kernelModel.isClassificationModel();
        }
        return index == 5;
    }

    @Override
    public String mapIndex(int column, int value) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.index2LabelMap.get(value);
        }
        if (column == 5) {
            if (value == 0) {
                return "no support vector";
            }
            return "support vector";
        }
        return null;
    }

    @Override
    public int mapString(int column, String value) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.label2IndexMap.get(value);
        }
        if (column == 5) {
            if ("no support vector".equals(value)) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public int getNumberOfValues(int column) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.index2LabelMap.size();
        }
        if (column == 5) {
            return 2;
        }
        return -1;
    }

    @Override
    public String getColumnName(int i) {
        if (i < 6) {
            return KernelModelRow2DataTableRowWrapper.SPECIAL_COLUMN_NAMES[i];
        }
        return "attribute" + (i - 6 + 1);
    }

    @Override
    public int getColumnIndex(String name) {
        int i = 0;
        while (i < 6) {
            if (KernelModelRow2DataTableRowWrapper.SPECIAL_COLUMN_NAMES[i].equals(name)) {
                return i;
            }
            ++i;
        }
        if (name.startsWith("attribute")) {
            return Integer.parseInt(name.substring("attribute".length())) - 1;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public double getColumnWeight(int column) {
        return Double.NaN;
    }

    @Override
    public int getNumberOfColumns() {
        return this.kernelModel.getNumberOfAttributes() + 6;
    }

    @Override
    public int getNumberOfRows() {
        if (this.sampleMapping == null) {
            return this.kernelModel.getNumberOfExamples();
        }
        return this.sampleMapping.length;
    }

    @Override
    public String getName() {
        return "Kernel Model";
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTableKernelModelAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int index) {
        if (this.sampleMapping == null) {
            return new KernelModelRow2DataTableRowWrapper(this.kernelModel, this, index);
        }
        return new KernelModelRow2DataTableRowWrapper(this.kernelModel, this, this.sampleMapping[index]);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new KernelModelIterator(this);
    }

    @Override
    public void sample(int newSize) {
        double ratio = (double)newSize / (double)this.getNumberOfRows();
        Random random = new Random(2001L);
        LinkedList<Integer> usedRows = new LinkedList<Integer>();
        int i = 0;
        while (i < this.getNumberOfRows()) {
            if (random.nextDouble() <= ratio) {
                int index = i;
                if (this.sampleMapping != null) {
                    index = this.sampleMapping[index];
                }
                usedRows.add(index);
            }
            ++i;
        }
        this.sampleMapping = new int[usedRows.size()];
        int counter = 0;
        Iterator i2 = usedRows.iterator();
        while (i2.hasNext()) {
            this.sampleMapping[counter++] = (Integer)i2.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KernelModelIterator
    implements Iterator<DataTableRow> {
        private int counter = 0;
        private DataTableKernelModelAdapter adapter;

        public KernelModelIterator(DataTableKernelModelAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.adapter.getNumberOfRows();
        }

        @Override
        public DataTableRow next() {
            DataTableRow row = this.adapter.getRow(this.counter);
            ++this.counter;
            return row;
        }

        @Override
        public void remove() {
            throw new RuntimeException("DataTable.KernelModelIterator: remove not supported!");
        }
    }
}

