/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.AbstractDataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.datatable.Example2DataTableRowIterator;
import edu.udo.cs.yale.datatable.Example2DataTableRowWrapper;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableExampleSetAdapter
extends AbstractDataTable {
    private ExampleSet exampleSet;
    private List<Attribute> allAttributes = new ArrayList<Attribute>();
    private int numberOfRegularAttributes = 0;
    private AttributeWeights weights = null;

    public DataTableExampleSetAdapter(ExampleSet exampleSet, AttributeWeights weights) {
        this.exampleSet = exampleSet;
        this.weights = weights;
        Attribute idAttribute = exampleSet.getAttributes().getId();
        Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (idAttribute != null && attribute.equals(idAttribute)) continue;
            this.allAttributes.add(attribute);
        }
        this.numberOfRegularAttributes = exampleSet.getAttributes().size();
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return this.allAttributes.size() - this.numberOfRegularAttributes;
    }

    @Override
    public boolean isSpecial(int index) {
        return index >= this.numberOfRegularAttributes;
    }

    @Override
    public boolean isNominal(int index) {
        return this.allAttributes.get(index).isNominal();
    }

    @Override
    public String mapIndex(int column, int value) {
        return this.allAttributes.get(column).getMapping().mapIndex(value);
    }

    @Override
    public int mapString(int column, String value) {
        return this.allAttributes.get(column).getMapping().mapString(value);
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.allAttributes.get(column).getMapping().size();
    }

    @Override
    public String getColumnName(int i) {
        return this.allAttributes.get(i).getName();
    }

    @Override
    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this.allAttributes.size()) {
            if (this.allAttributes.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return this.weights != null;
    }

    @Override
    public double getColumnWeight(int column) {
        if (this.weights == null) {
            return Double.NaN;
        }
        return this.weights.getWeight(this.getColumnName(column));
    }

    @Override
    public int getNumberOfColumns() {
        return this.allAttributes.size();
    }

    @Override
    public String getName() {
        return "Example Set";
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTableExampleSetAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int index) {
        return new Example2DataTableRowWrapper(this.exampleSet.getExample(index), this.allAttributes, this.exampleSet.getAttributes().getId());
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new Example2DataTableRowIterator(this.exampleSet.iterator(), this.allAttributes, this.exampleSet.getAttributes().getId());
    }

    @Override
    public int getNumberOfRows() {
        return this.exampleSet.size();
    }

    @Override
    public void sample(int newSize) {
        double ratio = (double)newSize / (double)this.getNumberOfRows();
        this.exampleSet = new SplittedExampleSet(this.exampleSet, ratio, 1, -1);
        ((SplittedExampleSet)this.exampleSet).selectSingleSubset(0);
    }
}

