/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.AbstractDataTable;
import edu.udo.cs.yale.datatable.CorrelationMatrixRow2DataTableRowIterator;
import edu.udo.cs.yale.datatable.CorrelationMatrixRow2DataTableRowWrapper;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.operator.visualization.CorrelationMatrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableCorrelationMatrixAdapter
extends AbstractDataTable {
    private CorrelationMatrix matrix;
    private String[] index2NameMap;
    private Map<String, Integer> name2IndexMap = new HashMap<String, Integer>();

    public DataTableCorrelationMatrixAdapter(CorrelationMatrix matrix, String[] columnNames) {
        this.matrix = matrix;
        this.index2NameMap = columnNames;
        int i = 0;
        while (i < this.index2NameMap.length) {
            this.name2IndexMap.put(this.index2NameMap[i], i);
            ++i;
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 0;
    }

    @Override
    public boolean isSpecial(int index) {
        return false;
    }

    @Override
    public boolean isNominal(int index) {
        return index == 0;
    }

    @Override
    public String mapIndex(int column, int value) {
        return this.index2NameMap[value];
    }

    @Override
    public int mapString(int column, String value) {
        Integer result = this.name2IndexMap.get(value);
        if (result == null) {
            return -1;
        }
        return result;
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.index2NameMap.length;
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return "Attributes";
        }
        return this.index2NameMap[i - 1];
    }

    @Override
    public int getColumnIndex(String name) {
        if (name.equals("Attributes")) {
            return 0;
        }
        return this.mapString(0, name) + 1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public double getColumnWeight(int column) {
        return Double.NaN;
    }

    @Override
    public int getNumberOfColumns() {
        return this.index2NameMap.length + 1;
    }

    @Override
    public String getName() {
        return "Correlation Matrix";
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTableCorrelationMatrixAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int index) {
        return new CorrelationMatrixRow2DataTableRowWrapper(this.matrix, index);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new CorrelationMatrixRow2DataTableRowIterator(this.matrix);
    }

    @Override
    public int getNumberOfRows() {
        return this.index2NameMap.length;
    }

    @Override
    public void sample(int newSize) {
    }
}

