/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.datatable;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableListener;
import edu.udo.cs.yale.datatable.DataTableRow;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDataTable
implements DataTable {
    private List<DataTableListener> listeners = new LinkedList<DataTableListener>();

    public String[] getColumnNames() {
        String[] result = new String[this.getNumberOfColumns()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColumnName(i);
            ++i;
        }
        return result;
    }

    public void addDataTableListener(DataTableListener dataTableListener) {
        this.listeners.add(dataTableListener);
    }

    public void removeDataTableListener(DataTableListener dataTableListener) {
        this.listeners.remove(dataTableListener);
    }

    protected void fireEvent() {
        Iterator<DataTableListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().dataTableUpdated(this);
        }
    }

    public String getValueAsString(DataTableRow row, int column) {
        if (this.isNominal(column)) {
            return this.mapIndex(column, (int)row.getValue(column));
        }
        return String.valueOf(row.getValue(column));
    }

    public void write(PrintWriter out) throws IOException {
        out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            out.print(String.valueOf(j != 0 ? "\t" : "# ") + this.getColumnName(j));
            ++j;
        }
        out.println();
        for (DataTableRow row : this) {
            int j2 = 0;
            while (j2 < this.getNumberOfColumns()) {
                out.print(String.valueOf(j2 != 0 ? "\t" : "") + this.getValueAsString(row, j2));
                ++j2;
            }
            out.println();
        }
        out.flush();
    }

    public boolean containsMissingValues() {
        for (DataTableRow row : this) {
            int j = 0;
            while (j < this.getNumberOfColumns()) {
                if (Double.isNaN(row.getValue(j))) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }
}

