/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.IOException;

public class YaleCommandLine
extends Yale
implements BreakpointListener {
    private static final String LICENSE = "Yale version " + YaleCommandLine.getVersion() + ", Copyright (C) 2001-2006" + Tools.getLineSeparator() + "Yale comes with ABSOLUTELY NO WARRANTY; This is free software," + Tools.getLineSeparator() + "and you are welcome to redistribute it under certain conditions;" + Tools.getLineSeparator() + "see license information in the file named LICENSE.";
    private boolean showLogo = false;
    private String experimentfile = null;

    public void breakpointReached(Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":" + Tools.getLineSeparator() + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(operator).start();
    }

    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.experimentfile = null;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-l")) {
                this.showLogo = true;
            } else {
                this.experimentfile = argv[i];
            }
            ++i;
        }
        if (this.experimentfile == null) {
            YaleCommandLine.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: " + YaleCommandLine.class.getName() + " EXPERIMENTFILE");
        System.exit(1);
    }

    private void run() {
        ParameterService.ensureYaleHomeSet();
        try {
            if (this.showLogo) {
                YaleCommandLine.showSplash();
            }
            if (this.showLogo) {
                YaleCommandLine.hideSplash();
            }
            YaleCommandLine.init();
        }
        catch (IOException e) {
            System.err.println("ERROR: Cannot initialize YALE...");
            YaleCommandLine.quit(1);
        }
        Experiment experiment = null;
        try {
            experiment = YaleCommandLine.readExperimentFile(new File(this.experimentfile));
        }
        catch (Exception e) {
            System.err.println("ERROR: Cannot read experiment '" + this.experimentfile + "'...");
            YaleCommandLine.quit(1);
        }
        if (experiment != null) {
            try {
                LogService.init(experiment);
                experiment.addBreakpointListener(this);
                IOContainer results = experiment.run();
                experiment.getRootOperator().sendEmail(results, null);
                System.out.println("Experiment finished successfully");
                YaleCommandLine.quit(0);
            }
            catch (Throwable e) {
                LogService.logException(null, experiment, e);
                LogService.logMessageWithTree("Experiment failed!", 7, experiment, experiment.getCurrentOperator());
                try {
                    experiment.getRootOperator().sendEmail(null, e);
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                System.err.println("Experiment not successful");
                YaleCommandLine.quit(1);
            }
        }
    }

    public static void main(String[] argv) {
        System.out.println(LICENSE);
        YaleCommandLine main = new YaleCommandLine();
        main.parseArguments(argv);
        main.run();
    }

    private static class WaitForKeyThread
    extends Thread {
        private Operator operator;

        public WaitForKeyThread(Operator operator) {
            this.operator = operator;
        }

        public void run() {
            try {
                System.in.read();
            }
            catch (IOException e) {
                System.err.println("Error occured: " + e.getMessage());
            }
            this.operator.resume();
        }
    }
}

