/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.ConsoleInputHandler;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.InputHandler;
import edu.udo.cs.yale.Version;
import edu.udo.cs.yale.gui.dialog.SplashScreen;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.jdbc.DatabaseService;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Yale {
    private static final Set<ParameterType> PROPERTY_TYPES = new TreeSet<ParameterType>();
    private static InputHandler inputHandler;
    private static SplashScreen splashScreen;

    static {
        System.setProperty("yale.version", Yale.getVersion());
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.editor", "Path to external Java editor. %f is replaced by filename and %l by the linenumber.", true));
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.sendmail.command", "Path to sendmail. Used for email notifications.", true));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.general.logfile.format", "Use unix special characters for logfile highlighting (requires new Yale instance).", false));
        inputHandler = new ConsoleInputHandler();
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static Experiment readExperimentFile(File experimentfile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        try {
            LogService.logMessage("Reading experiment file '" + experimentfile + "'.", 2);
            if (!experimentfile.exists() || !experimentfile.canRead()) {
                LogService.logMessage("Cannot read config file '" + experimentfile + "'!", 7);
            }
            return new Experiment(experimentfile);
        }
        catch (XMLException e) {
            throw new XMLException(String.valueOf(experimentfile.getName()) + ":" + e.getMessage());
        }
    }

    public static void init() throws IOException {
        String loadWekaString = System.getProperty("yale.init.weka");
        boolean loadWeka = Tools.booleanValue(loadWekaString, true);
        String loadJDBCDirString = System.getProperty("yale.init.jdbc.lib");
        boolean loadJDBCDir = Tools.booleanValue(loadJDBCDirString, true);
        String loadJDBCClasspathString = System.getProperty("yale.init.jdbc.classpath");
        boolean loadJDBCClasspath = Tools.booleanValue(loadJDBCClasspathString, false);
        String loadPluginsString = System.getProperty("yale.init.plugins");
        boolean loadPlugins = Tools.booleanValue(loadPluginsString, true);
        Yale.init(null, loadWeka, loadJDBCDir, loadJDBCClasspath, loadPlugins);
    }

    public static void init(boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) throws IOException {
        Yale.init(null, addWekaOperators, searchJDBCInLibDir, searchJDBCInClasspath, addPlugins);
    }

    public static void init(InputStream operatorsXMLStream, boolean addWekaOperators, boolean searchJDBCInLibDir, boolean searchJDBCInClasspath, boolean addPlugins) throws IOException {
        ParameterService.ensureYaleHomeSet();
        Yale.splashMessage("Init Setup");
        LogService.logMessage("Initialization Settings", 3);
        LogService.logMessage("----------------------------------------------------", 3);
        LogService.logMessage("Load Weka operators: " + addWekaOperators, 3);
        LogService.logMessage("Load JDBC drivers from lib directory: " + searchJDBCInLibDir, 3);
        LogService.logMessage("Load JDBC drivers from classpath: " + searchJDBCInClasspath, 3);
        LogService.logMessage("Load plugins: " + addPlugins, 3);
        LogService.logMessage("----------------------------------------------------", 3);
        Yale.splashMessage("Initialising Operators");
        ParameterService.init(operatorsXMLStream, addWekaOperators);
        Yale.splashMessage("Loading JDBC Drivers");
        DatabaseService.init(searchJDBCInLibDir, searchJDBCInClasspath);
        Yale.splashMessage("Register Plugins");
        Plugin.registerAllPlugins();
        Yale.splashMessage("Define XML Serialization Alias Pairs");
        OperatorService.defineIOObjectXMLAliasPairs();
    }

    public static SplashScreen showSplash() {
        try {
            URL url = Tools.getResource("yale_logo_java.gif");
            BufferedImage logo = null;
            if (url != null) {
                logo = ImageIO.read(url);
            }
            splashScreen = new SplashScreen("YALE", Yale.getVersion(), logo);
            splashScreen.showSplashScreen();
            return splashScreen;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void hideSplash() {
        splashScreen.dispose();
    }

    public static void splashMessage(String message) {
        if (splashScreen != null) {
            splashScreen.setMessage(message);
        }
    }

    public static void setInputHandler(InputHandler inputHandler) {
        Yale.inputHandler = inputHandler;
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static Set<ParameterType> getYaleProperties() {
        return PROPERTY_TYPES;
    }

    public static void registerYaleProperty(ParameterType type) {
        PROPERTY_TYPES.add(type);
    }

    public static void quit(int errorcode) {
        Runtime.getRuntime().runFinalization();
        System.exit(errorcode);
    }
}

