/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.Experiment;
import java.util.HashMap;
import java.util.Map;

public class MacroHandler {
    private static final String[] PREDEFINED_MACROS = new String[]{"experiment_name", "experiment_file", "experiment_path"};
    private static final int EXPERIMENT_NAME = 0;
    private static final int EXPERIMENT_FILE = 1;
    private static final int EXPERIMENT_PATH = 2;
    private Experiment experiment;
    private Map<String, String> macroMap = new HashMap<String, String>();

    public MacroHandler(Experiment experiment) {
        this.experiment = experiment;
    }

    public void clear() {
        this.macroMap.clear();
    }

    public void addMacro(String macro, String value) {
        this.macroMap.put(macro, value);
    }

    public String getMacro(String macro) {
        int i = 0;
        while (i < PREDEFINED_MACROS.length) {
            if (PREDEFINED_MACROS[i].equals(macro)) {
                switch (i) {
                    case 0: {
                        String fileName = this.experiment.getExperimentFile().getName();
                        return fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    case 1: {
                        return this.experiment.getExperimentFile().getName();
                    }
                    case 2: {
                        return this.experiment.getExperimentFile().getAbsolutePath();
                    }
                }
            }
            ++i;
        }
        return this.macroMap.get(macro);
    }

    public String toString() {
        return this.macroMap.toString();
    }
}

