/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.MacroHandler;
import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.WrongNumberOfInnerOperatorsException;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ObjectVisualizerService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.ResultService;
import edu.udo.cs.yale.tools.TempFileService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment
implements Cloneable {
    public static final int EXPERIMENT_STATE_UNKNOWN = -1;
    public static final int EXPERIMENT_STATE_STOPPED = 0;
    public static final int EXPERIMENT_STATE_PAUSED = 1;
    public static final int EXPERIMENT_STATE_RUNNING = 2;
    private ExperimentOperator rootOperator;
    private Operator currentOperator;
    private File experimentFile;
    private List<BreakpointListener> breakpointListeners = new LinkedList<BreakpointListener>();
    private boolean stopExperiment = false;
    private MacroHandler macroHandler = new MacroHandler(this);
    private Map<String, Operator> operatorNameMap = new HashMap<String, Operator>();
    private Map<String, DataTable> dataTableMap = new HashMap<String, DataTable>();
    private int experimentState = 0;

    public Experiment() {
        try {
            ExperimentOperator root = (ExperimentOperator)OperatorService.createOperator("Experiment");
            root.rename("Root");
            this.setRootOperator(root);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize root operator of the experiment: " + e.getMessage(), e);
        }
    }

    public Experiment(URL url) throws IOException, XMLException {
        InputStream in = url.openStream();
        this.readExperiment(in);
        in.close();
    }

    public Experiment(File file) throws IOException, XMLException {
        FileInputStream in = new FileInputStream(file);
        this.readExperiment(in);
        ((InputStream)in).close();
        this.experimentFile = file;
    }

    public Experiment(String xmlString) throws IOException, XMLException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        this.readExperiment(in);
        in.close();
    }

    public Experiment(InputStream in) throws IOException, XMLException {
        this.readExperiment(in);
    }

    private Experiment(Experiment other) {
        this();
        this.setRootOperator((ExperimentOperator)other.rootOperator.cloneOperator(other.rootOperator.getName()));
        this.currentOperator = null;
        this.experimentFile = other.experimentFile != null ? new File(other.experimentFile.getAbsolutePath()) : null;
        this.breakpointListeners = other.breakpointListeners;
    }

    public Object clone() {
        return new Experiment(this);
    }

    public synchronized void setExperimentState(int state) {
        this.experimentState = state;
    }

    public synchronized int getExperimentState() {
        return this.experimentState;
    }

    public MacroHandler getMacroHandler() {
        return this.macroHandler;
    }

    public void clearMacros() {
        this.macroHandler.clear();
    }

    public boolean dataTableExists(String name) {
        return this.dataTableMap.get(name) != null;
    }

    public DataTable addDataTable(DataTable table) {
        this.dataTableMap.put(table.getName(), table);
        return table;
    }

    public DataTable getDataTable(String name) {
        return this.dataTableMap.get(name);
    }

    public Collection<DataTable> getDataTables() {
        return this.dataTableMap.values();
    }

    public void clearDataTables() {
        this.dataTableMap.clear();
    }

    public void setRootOperator(ExperimentOperator root) {
        this.rootOperator = root;
        this.operatorNameMap.clear();
        this.rootOperator.setExperiment(this);
    }

    public ExperimentOperator getRootOperator() {
        return this.rootOperator;
    }

    public void setupFromXML(String xmlString) throws IOException, XMLException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        this.readExperiment(in);
        in.close();
    }

    public File getExperimentFile() {
        return this.experimentFile;
    }

    public Operator getOperator(String name) {
        return this.operatorNameMap.get(name);
    }

    public Operator getCurrentOperator() {
        return this.currentOperator;
    }

    public Collection<Operator> getAllOperators() {
        List<Operator> result = this.rootOperator.getAllInnerOperators();
        result.add(0, this.rootOperator);
        return result;
    }

    public Collection<String> getAllOperatorNames() {
        LinkedList<String> allNames = new LinkedList<String>();
        for (Operator o : this.getAllOperators()) {
            allNames.add(o.getName());
        }
        return allNames;
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
    }

    public void addBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public void removeBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    public void fireBreakpointEvent(Operator operator, IOContainer ioContainer, int location) {
        Iterator<BreakpointListener> i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            i.next().breakpointReached(operator, ioContainer, location);
        }
    }

    public void fireResumeEvent() {
        Iterator<BreakpointListener> i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            i.next().resume();
        }
    }

    private int checkIO(IOContainer inputContainer) {
        IOObject[] inputObjects = inputContainer.getIOObjects();
        Class[] inputClasses = new Class[inputObjects.length];
        int i = 0;
        while (i < inputObjects.length) {
            inputClasses[i] = inputObjects[i].getClass();
            ++i;
        }
        LogService.logMessage("Checking i/o classes...", 3);
        try {
            Class[] output = this.rootOperator.checkIO(inputClasses);
            if (output.length == 0) {
                LogService.logMessage("i/o classes are ok.", 3);
            } else {
                String left = "";
                int i2 = 0;
                while (i2 < output.length) {
                    left = String.valueOf(left) + Tools.classNameWOPackage(output[i2]);
                    if (i2 < output.length - 1) {
                        left = String.valueOf(left) + ", ";
                    }
                    ++i2;
                }
                LogService.logMessage("i/o classes are ok. Experiment output: " + left + ".", 3);
            }
            return 0;
        }
        catch (IllegalInputException e) {
            if (e.getOperator() != null) {
                e.getOperator().addError(e.getMessage());
            }
            return 1;
        }
        catch (WrongNumberOfInnerOperatorsException e) {
            if (e.getOperator() != null) {
                e.getOperator().addError(e.getMessage());
            }
            return 1;
        }
    }

    private int checkNumberOfInnerOperators() {
        LogService.logMessage("Checking experimental setup...", 3);
        int errorCount = this.rootOperator.checkNumberOfInnerOperators();
        if (errorCount == 0) {
            LogService.logMessage("Inner operators are ok.", 3);
        } else {
            LogService.logMessage("Experimental setup not ok", 6);
        }
        return errorCount;
    }

    private int checkProperties() {
        LogService.logMessage("Checking properties...", 3);
        int errorCount = this.rootOperator.checkProperties();
        if (errorCount == 0) {
            LogService.logMessage("Properties are ok.", 3);
        } else {
            LogService.logMessage("Properties are not ok", 6);
        }
        return errorCount;
    }

    private int performAdditionalChecks() {
        try {
            this.rootOperator.performAdditionalChecks();
            return 0;
        }
        catch (UserError e) {
            LogService.logMessage(e.getMessage(), 6);
            return 1;
        }
    }

    public boolean checkExperiment(IOContainer inputContainer) {
        boolean ok = true;
        this.rootOperator.clearErrorList();
        int errorCount = this.checkProperties();
        if ((errorCount += this.checkNumberOfInnerOperators()) == 0) {
            errorCount += this.performAdditionalChecks();
        }
        if (errorCount == 0) {
            errorCount += this.checkIO(inputContainer);
        }
        if (errorCount == 0) {
            LogService.logMessage("Experiment ok.", 3);
        } else {
            LogService.logMessage("There were " + errorCount + " errors.", 6);
            ok = false;
        }
        int deprecationCount = this.rootOperator.checkDeprecations();
        if (deprecationCount > 0) {
            LogService.logMessage("Deprecations: " + deprecationCount + (deprecationCount == 1 ? " usage" : " usages") + " of deprecated operators.", 4);
        }
        return ok;
    }

    private void prepareRun(IOContainer inputContainer) throws OperatorException {
        this.stopExperiment = false;
        LogService.logMessage("Initialising experiment", 3);
        RandomGenerator.init(this);
        ResultService.init(this);
        TempFileService.init(this);
        ObjectVisualizerService.clearVisualizers();
        this.checkExperiment(inputContainer);
        this.clearDataTables();
        this.clearMacros();
        AttributeFactory.resetNameCounters();
        LogService.logMessage("Experiment initialised", 3);
    }

    public IOContainer run() throws OperatorException {
        return this.run(new IOContainer());
    }

    public IOContainer run(IOContainer input) throws OperatorException {
        this.prepareRun(input);
        long start = System.currentTimeMillis();
        LogService.logMessage("Experiment starts", 8);
        LogService.logMessage("Experiment:" + Tools.getLineSeparator() + this.getRootOperator().createExperimentTree(3), 3);
        this.rootOperator.experimentStarts();
        try {
            IOContainer result = this.rootOperator.apply(input);
            long end = System.currentTimeMillis();
            LogService.logMessage("Experiment finished after " + (end - start) / 1000L + " seconds", 8);
            LogService.logMessage("Experiment:" + Tools.getLineSeparator() + this.getRootOperator().createExperimentTree(3), 3);
            LogService.logMessage("Produced output:" + Tools.getLineSeparator() + result, 3);
            LogService.logMessage("Experiment finished successfully", 8);
            IOContainer iOContainer = result;
            return iOContainer;
        }
        catch (OperatorException e) {
            throw e;
        }
        finally {
            this.tearDown();
        }
    }

    public void stop() {
        this.stopExperiment = true;
    }

    public boolean shouldStop() {
        return this.stopExperiment;
    }

    private void tearDown() {
        try {
            this.rootOperator.experimentFinished();
        }
        catch (OperatorException e) {
            LogService.logMessage("Problem during finishing the experiment: " + e.getMessage(), 6);
        }
        ResultService.close();
        TempFileService.deleteTempDir();
        LogService.flush();
    }

    public void save() throws IOException {
        this.save(this.experimentFile);
    }

    public void save(File file) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        this.rootOperator.writeXML(writer, "");
        writer.close();
        LogService.logMessage("Wrote experiment file '" + file + "'.", 2);
    }

    public void setExperimentFile(File file) {
        this.experimentFile = file;
    }

    public File resolveFileName(String name) {
        File workingDir = new File(System.getProperty("user.dir"));
        return Tools.getFile(this.experimentFile != null ? this.experimentFile.getParentFile() : workingDir, name);
    }

    public File createFile(String name) {
        File file = this.resolveFileName(name);
        Tools.mkdir(file.getParentFile());
        return file;
    }

    public void readExperiment(InputStream in) throws XMLException, IOException {
        Map<String, Operator> nameMapBackup = this.operatorNameMap;
        this.operatorNameMap = new HashMap<String, Operator>();
        try {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                Operator root = Operator.createFromXML(document.getDocumentElement());
                if (!(root instanceof ExperimentOperator)) {
                    throw new XMLException("Outermost operator must be Experiment!");
                }
                this.rootOperator = (ExperimentOperator)root;
                this.setRootOperator(this.rootOperator);
                nameMapBackup = this.operatorNameMap;
            }
            catch (ParserConfigurationException e) {
                throw new XMLException(e.toString(), e);
            }
            catch (SAXException e) {
                throw new XMLException("Cannot parse document: " + e, e);
            }
        }
        finally {
            this.operatorNameMap = nameMapBackup;
        }
    }

    public String registerName(String name, Operator operator) {
        if (this.operatorNameMap.get(name) != null) {
            String baseName = name;
            int index = baseName.indexOf(" (");
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            int i = 2;
            while (this.operatorNameMap.get(String.valueOf(baseName) + " (" + i + ")") != null) {
                ++i;
            }
            String newName = String.valueOf(baseName) + " (" + i + ")";
            this.operatorNameMap.put(newName, operator);
            return newName;
        }
        this.operatorNameMap.put(name, operator);
        return name;
    }

    public void unregisterName(String name) {
        this.operatorNameMap.remove(name);
    }
}

