/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.SVM;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVM;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;

public class SVMpattern
extends SVM {
    private boolean calculateXiAlpha = false;

    public SVMpattern() {
    }

    public SVMpattern(Operator paramOperator, Kernel kernel, ExampleSet exampleSet, edu.udo.cs.yale.example.ExampleSet yaleExamples) throws UndefinedParameterError {
        super(paramOperator, kernel, exampleSet, yaleExamples);
        this.calculateXiAlpha = paramOperator.getParameterAsBoolean("estimate_performance");
    }

    protected void optimize() {
        int j;
        double target_tmp;
        this.qp.b[0] = 0.0;
        int i = 0;
        while (i < this.working_set_size) {
            this.qp.b[0] = this.qp.b[0] + this.alphas[this.working_set[i]];
            ++i;
        }
        double[] my_primal = this.primal;
        double new_target = 0.0;
        double old_target = 0.0;
        i = 0;
        while (i < this.working_set_size) {
            target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
            j = 0;
            while (j < i) {
                target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                ++j;
            }
            old_target += (target_tmp += this.qp.c[i]) * my_primal[i];
            ++i;
        }
        double new_constraint_sum = 0.0;
        double my_is_zero = this.is_zero;
        int sv_count = this.working_set_size;
        boolean KKTerror = true;
        boolean convError = false;
        this.qp.max_allowed_error = this.convergence_epsilon;
        this.qp.x = my_primal;
        this.qp.lambda_eq = this.lambda_eq;
        this.qp.solve();
        my_primal = this.qp.x;
        this.lambda_WS = this.qp.lambda_eq;
        while (KKTerror) {
            sv_count = this.working_set_size;
            new_constraint_sum = this.qp.b[0];
            i = 0;
            while (i < this.working_set_size) {
                if (my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.l[i];
                    --sv_count;
                } else if (this.qp.u[i] - my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.u[i];
                    --sv_count;
                }
                new_constraint_sum -= this.qp.A[i] * my_primal[i];
                ++i;
            }
            if (sv_count > 0) {
                this.logln(5, "adjusting " + sv_count + " alphas by " + (new_constraint_sum /= (double)sv_count));
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        int n = i;
                        my_primal[n] = my_primal[n] + this.qp.A[i] * new_constraint_sum;
                    }
                    ++i;
                }
            } else if (Math.abs(new_constraint_sum) > (double)this.working_set_size * this.is_zero) {
                this.logln(5, "WARNING: No SVs, constraint_sum = " + new_constraint_sum);
                old_target = -4.9E-324;
                convError = true;
            }
            new_target = 0.0;
            i = 0;
            while (i < this.working_set_size) {
                target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
                j = 0;
                while (j < i) {
                    target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                    ++j;
                }
                new_target += (target_tmp += this.qp.c[i]) * my_primal[i];
                ++i;
            }
            if (new_target < old_target) {
                KKTerror = false;
                if (this.descend < old_target - new_target) {
                    this.target_count = 0;
                } else {
                    convError = true;
                }
                this.logln(5, "descend = " + (old_target - new_target));
                continue;
            }
            if (sv_count > 0) {
                my_is_zero = Double.MAX_VALUE;
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        if (my_primal[i] - this.qp.l[i] < my_is_zero) {
                            my_is_zero = my_primal[i] - this.qp.l[i];
                        }
                        if (this.qp.u[i] - my_primal[i] < my_is_zero) {
                            my_is_zero = this.qp.u[i] - my_primal[i];
                        }
                    }
                    ++i;
                }
                if (this.target_count == 0) {
                    my_is_zero *= 2.0;
                }
                this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), adjusting is_zero to " + my_is_zero);
                this.logln(5, "new_target = " + new_target);
                continue;
            }
            this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), stopping.");
            KKTerror = false;
            convError = true;
        }
        if (convError) {
            ++this.target_count;
            if (old_target < new_target) {
                i = 0;
                while (i < this.working_set_size) {
                    my_primal[i] = this.qp.A[i] * this.alphas[this.working_set[i]];
                    ++i;
                }
                this.logln(5, "WARNING: Convergence error, restoring old primals");
            }
        }
        if (this.target_count > 50) {
            this.convergence_epsilon *= 2.0;
            this.feasible_epsilon = this.convergence_epsilon;
            this.logln(1, "WARNING: reducing KKT precision to " + this.convergence_epsilon);
            this.target_count = 0;
        }
    }

    protected final boolean is_alpha_neg(int i) {
        boolean result = this.ys[i] > 0.0;
        return result;
    }

    protected final double nabla(int i) {
        double result = this.is_alpha_neg(i) ? this.sum[i] - 1.0 : -this.sum[i] - 1.0;
        return result;
    }

    protected void print_statistics() {
        int j;
        double alpha;
        int i;
        int dim = this.the_examples.get_dim();
        int svs = 0;
        int bsv = 0;
        int correct_pos = 0;
        int correct_neg = 0;
        int total_pos = 0;
        int total_neg = 0;
        double min_lambda = Double.MAX_VALUE;
        double b = this.the_examples.get_b();
        double r_delta = 0.0;
        boolean do_xi_alpha = false;
        double norm_w = 0.0;
        double max_norm_x = 0.0;
        double min_norm_x = 1.0E20;
        double norm_x = 0.0;
        int estim_pos = 0;
        int estim_neg = 0;
        if (this.calculateXiAlpha) {
            do_xi_alpha = true;
            i = 0;
            while (i < this.examples_total) {
                norm_w += this.alphas[i] * this.sum[i];
                alpha = this.alphas[i];
                if (alpha != 0.0) {
                    norm_x = this.the_kernel.calculate_K(i, i);
                    if (norm_x > max_norm_x) {
                        max_norm_x = norm_x;
                    }
                    if (norm_x < min_norm_x) {
                        min_norm_x = norm_x;
                    }
                }
                ++i;
            }
            r_delta = 0.0;
            j = 0;
            while (j < this.examples_total) {
                norm_x = this.the_kernel.calculate_K(j, j);
                i = 0;
                while (i < this.examples_total) {
                    double r_current = norm_x - this.the_kernel.calculate_K(i, j);
                    if (r_current > r_delta) {
                        r_delta = r_current;
                    }
                    ++i;
                }
                ++j;
            }
        }
        i = 0;
        while (i < this.examples_total) {
            double xi;
            if (this.lambda(i) < min_lambda) {
                min_lambda = this.lambda(i);
            }
            double y = this.ys[i];
            double prediction = this.sum[i] + b;
            alpha = this.alphas[i];
            if (y > 0.0) {
                if (prediction > 0.0) {
                    ++correct_pos;
                }
                if (do_xi_alpha && 2.0 * alpha * r_delta + (xi = prediction > 1.0 ? 0.0 : 1.0 - prediction) >= 1.0) {
                    ++estim_pos;
                }
                ++total_pos;
            } else {
                if (prediction <= 0.0) {
                    ++correct_neg;
                }
                if (do_xi_alpha && 2.0 * -alpha * r_delta + (xi = prediction < -1.0 ? 0.0 : 1.0 + prediction) >= 1.0) {
                    ++estim_neg;
                }
                ++total_neg;
            }
            if (alpha != 0.0) {
                ++svs;
                if (alpha == this.cPos[i] || alpha == -this.cNeg[i]) {
                    ++bsv;
                }
            }
            ++i;
        }
        min_lambda = -min_lambda;
        this.logln(1, "Error on KKT is " + min_lambda);
        this.logln(1, String.valueOf(svs) + " SVs");
        this.logln(1, String.valueOf(bsv) + " BSVs");
        this.logln(1, "Accuracy : " + (double)(correct_pos + correct_neg) / (double)(total_pos + total_neg));
        this.logln(1, "Precision: " + (double)correct_pos / (double)(correct_pos + total_neg - correct_neg));
        this.logln(1, "Recall   : " + (double)correct_pos / (double)total_pos);
        this.logln(1, "Pred:\t+\t-");
        this.logln(1, "\t" + correct_pos + "\t" + (total_pos - correct_pos) + "\t(true pos)");
        this.logln(1, "\t" + (total_neg - correct_neg) + "\t" + correct_neg + "\t(true neg)");
        if (do_xi_alpha) {
            this.logln(1, "Xi-Alpha Accuracy" + (1.0 - (double)(estim_pos + estim_neg) / (double)(total_pos + total_neg)));
            this.logln(1, "Xi-Alpha Precision" + (double)(total_pos - estim_pos) / (double)(total_pos - estim_pos + estim_neg));
            this.logln(1, "Xi-Alpha Recall" + (1.0 - (double)estim_pos / (double)total_pos));
        }
        double[] w = new double[dim];
        j = 0;
        while (j < dim) {
            w[j] = 0.0;
            ++j;
        }
        i = 0;
        while (i < this.examples_total) {
            double[] x = this.the_examples.get_example(i).toDense(dim);
            alpha = this.alphas[i];
            j = 0;
            while (j < dim) {
                int n = j;
                w[n] = w[n] + alpha * x[j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dim) {
            this.logln(2, "w[" + j + "] = " + w[j]);
            ++j;
        }
        this.logln(2, "b = " + b);
        if (dim == 1) {
            this.logln(2, "y = " + w[0] + "*x+" + b);
        }
    }
}

