/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.Kernel;

import edu.udo.cs.mySVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelGaussianCombination
extends Kernel {
    private double sigma1 = 1.0;
    private double sigma2 = 0.0;
    private double sigma3 = 2.0;

    public String toString() {
        return "gaussian_combination(s1=" + this.sigma1 + ",s2=" + this.sigma2 + ",s3=" + this.sigma3 + ")";
    }

    public void setParameters(double sigma1, double sigma2, double sigma3) {
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.sigma3 = sigma3;
    }

    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double norm2 = this.norm2(x_index, x_att, y_index, y_att);
        double exp1 = this.sigma1 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma1);
        double exp2 = this.sigma2 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma2);
        double exp3 = this.sigma3 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma3);
        return exp1 + exp2 - exp3;
    }

    public void readKernelParameters(ObjectInputStream in) throws IOException {
        this.sigma1 = in.readDouble();
        this.sigma2 = in.readDouble();
        this.sigma3 = in.readDouble();
    }

    public void writeKernelParameters(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma1);
        out.writeDouble(this.sigma2);
        out.writeDouble(this.sigma3);
    }
}

