/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.Kernel;

import edu.udo.cs.mySVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelEpanechnikov
extends Kernel {
    private double sigma = 1.0;
    private double degree = 1.0;

    public String toString() {
        return "epanechnikov(s=" + this.sigma + ",d=" + this.degree + ")";
    }

    public void setParameters(double sigma, double degree) {
        this.sigma = sigma;
        this.degree = degree;
    }

    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double expression = this.norm2(x_index, x_att, y_index, y_att) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public void readKernelParameters(ObjectInputStream in) throws IOException {
        this.sigma = in.readDouble();
        this.degree = in.readDouble();
    }

    public void writeKernelParameters(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma);
        out.writeDouble(this.degree);
    }
}

