/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.Examples;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.tools.Tools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSet {
    private int dim;
    private int train_size;
    public double[][] atts;
    public int[][] index;
    public String[] ids;
    private double[] alphas;
    private double[] ys;
    private double b;
    private Example x;
    private Map<Integer, MeanVariance> meanVarianceMap = new HashMap<Integer, MeanVariance>();

    public ExampleSet(int size, double b) {
        this.train_size = size;
        this.b = b;
        this.atts = new double[this.train_size][];
        this.index = new int[this.train_size][];
        this.ys = new double[this.train_size];
        this.alphas = new double[this.train_size];
        this.ids = new String[size];
        this.x = new Example();
    }

    private static Map<Integer, MeanVariance> createMeanVariances(edu.udo.cs.yale.example.ExampleSet exampleSet) {
        int a;
        double[] sum = new double[exampleSet.getAttributes().size()];
        double[] squaredSum = new double[sum.length];
        for (edu.udo.cs.yale.example.Example example : exampleSet) {
            a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                int n = a;
                sum[n] = sum[n] + value;
                int n2 = a++;
                squaredSum[n2] = squaredSum[n2] + value * value;
            }
        }
        HashMap<Integer, MeanVariance> meanVariances = new HashMap<Integer, MeanVariance>();
        a = 0;
        while (a < sum.length) {
            int n = a;
            sum[n] = sum[n] / (double)exampleSet.size();
            int n3 = a;
            squaredSum[n3] = squaredSum[n3] / (double)exampleSet.size();
            meanVariances.put(a, new MeanVariance(sum[a], squaredSum[a] - sum[a] * sum[a]));
            ++a;
        }
        return meanVariances;
    }

    public ExampleSet(edu.udo.cs.yale.example.ExampleSet exampleSet, Attribute labelAttribute, boolean scale) {
        this(exampleSet, labelAttribute, scale ? ExampleSet.createMeanVariances(exampleSet) : new HashMap<Integer, MeanVariance>());
    }

    public ExampleSet(edu.udo.cs.yale.example.ExampleSet exampleSet, Attribute labelAttribute, Map<Integer, MeanVariance> meanVariances) {
        this(exampleSet.size(), 0.0);
        this.meanVarianceMap = meanVariances;
        Iterator reader = exampleSet.iterator();
        Attribute idAttribute = exampleSet.getAttributes().getId();
        int exampleCounter = 0;
        while (reader.hasNext()) {
            edu.udo.cs.yale.example.Example current = (edu.udo.cs.yale.example.Example)reader.next();
            LinkedHashMap<Integer, Double> attributeMap = new LinkedHashMap<Integer, Double>();
            int a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = current.getValue(attribute);
                if (!edu.udo.cs.yale.example.Tools.isDefault(attribute.getDefault(), value)) {
                    attributeMap.put(a, value);
                }
                if (a + 1 > this.dim) {
                    this.dim = a + 1;
                }
                ++a;
            }
            this.atts[exampleCounter] = new double[attributeMap.size()];
            this.index[exampleCounter] = new int[attributeMap.size()];
            Iterator i = attributeMap.entrySet().iterator();
            int attributeCounter = 0;
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Integer indexValue = (Integer)e.getKey();
                Double attributeValue = (Double)e.getValue();
                this.index[exampleCounter][attributeCounter] = indexValue;
                double value = attributeValue;
                MeanVariance meanVariance = this.meanVarianceMap.get(indexValue);
                if (meanVariance != null) {
                    value = meanVariance.getVariance() == 0.0 ? 0.0 : (value - meanVariance.getMean()) / Math.sqrt(meanVariance.getVariance());
                }
                this.atts[exampleCounter][attributeCounter] = value;
                ++attributeCounter;
            }
            if (labelAttribute != null) {
                double label = current.getValue(labelAttribute);
                this.ys[exampleCounter] = labelAttribute.isNominal() ? (double)(label == (double)labelAttribute.getMapping().getPositiveIndex() ? 1 : -1) : label;
            }
            if (idAttribute != null) {
                this.ids[exampleCounter] = current.getValueAsString(idAttribute);
            }
            ++exampleCounter;
        }
    }

    public ExampleSet(ObjectInputStream in) throws IOException {
        this(in.readInt(), in.readDouble());
        this.dim = in.readInt();
        String scaleString = in.readUTF();
        if (scaleString.equals("scale")) {
            int numberOfAttributes = in.readInt();
            this.meanVarianceMap = new HashMap<Integer, MeanVariance>();
            int i = 0;
            while (i < numberOfAttributes) {
                int index = in.readInt();
                double mean = in.readDouble();
                double variance = in.readDouble();
                this.meanVarianceMap.put(index, new MeanVariance(mean, variance));
                ++i;
            }
        }
        int e = 0;
        while (e < this.train_size) {
            this.index[e] = new int[in.readInt()];
            this.atts[e] = new double[this.index[e].length];
            int a = 0;
            while (a < this.index[e].length) {
                this.index[e][a] = in.readInt();
                this.atts[e][a] = in.readDouble();
                ++a;
            }
            this.alphas[e] = in.readDouble();
            this.ys[e] = in.readDouble();
            ++e;
        }
    }

    public Map<Integer, MeanVariance> getMeanVariances() {
        return this.meanVarianceMap;
    }

    public int getNumberOfSupportVectors() {
        int result = 0;
        int i = 0;
        while (i < this.alphas.length) {
            if (this.alphas[i] != 0.0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void writeSupportVectors(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getNumberOfSupportVectors());
        out.writeDouble(this.b);
        out.writeInt(this.dim);
        if (this.meanVarianceMap == null || this.meanVarianceMap.size() == 0) {
            out.writeUTF("noscale");
        } else {
            out.writeUTF("scale");
            out.writeInt(this.meanVarianceMap.size());
            for (Integer index : this.meanVarianceMap.keySet()) {
                MeanVariance meanVariance = this.meanVarianceMap.get(index);
                out.writeInt(index);
                out.writeDouble(meanVariance.getMean());
                out.writeDouble(meanVariance.getVariance());
            }
        }
        int e = 0;
        while (e < this.train_size) {
            if (this.alphas[e] != 0.0) {
                out.writeInt(this.atts[e].length);
                int a = 0;
                while (a < this.atts[e].length) {
                    out.writeInt(this.index[e][a]);
                    out.writeDouble(this.atts[e][a]);
                    ++a;
                }
                out.writeDouble(this.alphas[e]);
                out.writeDouble(this.ys[e]);
            }
            ++e;
        }
    }

    public int count_examples() {
        return this.train_size;
    }

    public int count_pos_examples() {
        int result = 0;
        int i = 0;
        while (i < this.train_size) {
            if (this.ys[i] > 0.0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public int get_dim() {
        return this.dim;
    }

    public Example get_example(int pos) {
        this.x.att = this.atts[pos];
        this.x.index = this.index[pos];
        return this.x;
    }

    public double get_y(int pos) {
        return this.ys[pos];
    }

    public void set_y(int pos, double y) {
        this.ys[pos] = y;
    }

    public double[] get_ys() {
        return this.ys;
    }

    public double get_alpha(int pos) {
        return this.alphas[pos];
    }

    public double[] get_alphas() {
        return this.alphas;
    }

    public void swap(int pos1, int pos2) {
        double[] dummyA = this.atts[pos1];
        this.atts[pos1] = this.atts[pos2];
        this.atts[pos2] = dummyA;
        int[] dummyI = this.index[pos1];
        this.index[pos1] = this.index[pos2];
        this.index[pos2] = dummyI;
        double dummyd = this.alphas[pos1];
        this.alphas[pos1] = this.alphas[pos2];
        this.alphas[pos2] = dummyd;
        dummyd = this.ys[pos1];
        this.ys[pos1] = this.ys[pos2];
        this.ys[pos2] = dummyd;
    }

    public double get_b() {
        return this.b;
    }

    public void set_b(double new_b) {
        this.b = new_b;
    }

    public void set_alpha(int pos, double alpha) {
        this.alphas[pos] = alpha;
    }

    public void clearAlphas() {
        int i = 0;
        while (i < this.alphas.length) {
            this.alphas[i] = 0.0;
            ++i;
        }
    }

    public String getId(int index) {
        return this.ids[index];
    }

    public String toString() {
        return this.toString(this.atts.length, false);
    }

    public String toString(boolean onlySV) {
        return this.toString(this.atts.length, onlySV);
    }

    public String toString(int numberOfExamples, boolean onlySV) {
        StringBuffer result = new StringBuffer("SVM Example Set (" + (onlySV ? String.valueOf(this.getNumberOfSupportVectors()) + " support vectors" : String.valueOf(this.train_size) + " examples") + "):" + Tools.getLineSeparator() + "b: " + this.b + Tools.getLineSeparator());
        int e = 0;
        while (e < numberOfExamples) {
            if (!onlySV || this.alphas[e] != 0.0) {
                int a = 0;
                while (a < this.atts[e].length) {
                    result.append(String.valueOf(this.index[e][a]) + ":");
                    result.append(String.valueOf(this.atts[e][a]) + " ");
                    ++a;
                }
                result.append(", alpha: " + this.alphas[e]);
                result.append(", y: " + this.ys[e] + Tools.getLineSeparator());
            }
            ++e;
        }
        return result.toString();
    }

    public static class MeanVariance {
        private double mean = 0.0;
        private double variance = 0.0;

        public MeanVariance(double mean, double variance) {
            this.mean = mean;
            this.variance = variance;
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            return this.variance;
        }
    }
}

