/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Util;

import Jama.Matrix;
import edu.udo.cs.yale.tools.Tools;
import java.util.LinkedList;

public class SECholeskyDecomposition {
    private Matrix L = null;
    private Matrix PTR = null;
    private LinkedList<PivotTransform> pivotTransformQueue = new LinkedList();
    private Matrix E = null;
    private double[] E_Diagonal = null;
    private double ENorm = 0.0;
    private double detL = 0.0;
    private int n = 0;

    public SECholeskyDecomposition(double[][] A) {
        this.decompose(new Matrix(A));
    }

    public SECholeskyDecomposition(Matrix A) {
        this.decompose(A);
    }

    private void swapRowsAndColumns(double[][] A, int i, int j, boolean isSymmetric, int offset) {
        i += offset;
        j += offset;
        if (!isSymmetric) {
            double[] tr = A[i];
            A[i] = A[j];
            A[j] = tr;
            int k = offset;
            while (k < this.n) {
                double tmp = A[k][i];
                A[k][i] = A[k][j];
                A[k][j] = tmp;
                ++k;
            }
        } else {
            double[] ti = new double[this.n];
            double[] tj = new double[this.n];
            if (i > j) {
                int t = i;
                i = j;
                j = t;
            }
            int k = offset;
            while (k < i) {
                ti[k] = A[i][k];
                ++k;
            }
            k = i;
            while (k < this.n) {
                ti[k] = A[k][i];
                ++k;
            }
            double tmp = ti[i];
            ti[i] = ti[j];
            ti[j] = tmp;
            k = offset;
            while (k < j) {
                tj[k] = A[j][k];
                ++k;
            }
            k = j;
            while (k < this.n) {
                tj[k] = A[k][j];
                ++k;
            }
            tmp = tj[i];
            tj[i] = tj[j];
            tj[j] = tmp;
            k = offset;
            while (k < i) {
                A[i][k] = tj[k];
                A[j][k] = ti[k];
                ++k;
            }
            k = i;
            while (k < j) {
                A[k][i] = tj[k];
                A[j][k] = ti[k];
                ++k;
            }
            k = j;
            while (k < this.n) {
                A[k][i] = tj[k];
                A[k][j] = ti[k];
                ++k;
            }
        }
    }

    private void decompose(Matrix MA_orig) {
        int k;
        double mach_eps = 2.23E-16;
        double tau = Math.pow(mach_eps, 0.3333333333333333);
        double tau_mod = Math.pow(mach_eps, 0.6666666666666666);
        double mu = 0.1;
        this.n = MA_orig.getRowDimension();
        this.E_Diagonal = new double[this.n];
        Matrix MA = (Matrix)MA_orig.clone();
        Matrix ML = new Matrix(this.n, this.n, 0.0);
        double[][] A = MA.getArray();
        double[][] L = ML.getArray();
        double delta_prev = 0.0;
        double delta = 0.0;
        boolean phaseone = true;
        int j = 0;
        MA.getColumnDimension();
        double gamma = 0.0;
        int i = 0;
        while (i < this.n) {
            if (Math.abs(A[i][i]) > gamma) {
                gamma = Math.abs(A[i][i]);
            }
            ++i;
        }
        while (j < this.n && phaseone) {
            int pivot = j;
            double pivot_v = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            i = j;
            while (i < this.n) {
                if (A[i][i] > pivot_v) {
                    pivot_v = A[i][i];
                    pivot = i;
                }
                if (A[i][i] < min) {
                    min = A[i][i];
                }
                ++i;
            }
            if (pivot_v < tau_mod * gamma || min < -mu * pivot_v) {
                phaseone = false;
                break;
            }
            if (pivot != j) {
                this.swapRowsAndColumns(A, 0, pivot - j, true, j);
                this.swapRowsAndColumns(L, j, pivot, false, 0);
                this.pivotTransformQueue.add(new PivotTransform(pivot, j));
            }
            min = Double.POSITIVE_INFINITY;
            i = j + 1;
            while (i < this.n) {
                double value = A[i][i] - A[i][j] * A[i][j] / A[j][j];
                if (value < min) {
                    min = value;
                }
                ++i;
            }
            if (min < -mu * gamma) {
                phaseone = false;
                break;
            }
            this.E_Diagonal[j] = 0.0;
            L[j][j] = Math.sqrt(A[j][j]);
            i = j + 1;
            while (i < this.n) {
                L[i][j] = A[i][j] / L[j][j];
                k = j + 1;
                while (k <= i) {
                    A[i][k] = A[i][k] - L[i][j] * L[k][j];
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        if (!phaseone && j == this.n - 1) {
            delta = -A[j][j] + Math.max(tau * -A[j][j] / (1.0 - tau), tau_mod * gamma);
            double[] dArray = A[j];
            int n = j;
            dArray[n] = dArray[n] + delta;
            L[j][j] = Math.sqrt(A[j][j]);
            this.E_Diagonal[j] = delta;
        }
        if (!phaseone && j < this.n - 1) {
            double lambda_hi;
            k = j;
            double[] g = new double[this.n - k];
            i = k;
            while (i < this.n) {
                double sum_l = 0.0;
                double sum_r = 0.0;
                int l = k;
                while (l < i) {
                    sum_l += Math.abs(A[i][l]);
                    ++l;
                }
                l = i + 1;
                while (l < this.n) {
                    sum_r += Math.abs(A[l][i]);
                    ++l;
                }
                g[i - k] = A[i][i] - sum_l - sum_r;
                ++i;
            }
            j = k;
            while (j < this.n - 2) {
                int gmax = j;
                double gmax_v = Double.NEGATIVE_INFINITY;
                i = j;
                while (i < this.n) {
                    if (g[i - k] > gmax_v) {
                        gmax_v = g[i - k];
                        gmax = i;
                    }
                    ++i;
                }
                if (gmax != j) {
                    this.swapRowsAndColumns(A, 0, gmax - j, true, j);
                    this.swapRowsAndColumns(L, j, gmax, false, 0);
                    this.pivotTransformQueue.add(new PivotTransform(gmax, j));
                }
                double normj = 0.0;
                i = j + 1;
                while (i < this.n) {
                    normj += Math.abs(A[i][j]);
                    ++i;
                }
                delta = Math.max(0.0, Math.max(-A[j][j] + Math.max(normj, tau_mod * gamma), delta_prev));
                if (delta > 0.0) {
                    double[] dArray = A[j];
                    int n = j;
                    dArray[n] = dArray[n] + delta;
                    delta_prev = delta;
                }
                this.E_Diagonal[j] = delta;
                if (Tools.isNotEqual(A[j][j], normj)) {
                    double t = 1.0 - normj / A[j][j];
                    i = j + 1;
                    while (i < this.n) {
                        int n = i - k;
                        g[n] = g[n] + t * Math.abs(A[i][j]);
                        ++i;
                    }
                }
                L[j][j] = Math.sqrt(A[j][j]);
                i = j + 1;
                while (i < this.n) {
                    L[i][j] = A[i][j] / L[j][j];
                    int l = j + 1;
                    while (l <= i) {
                        A[i][l] = A[i][l] - L[i][j] * L[l][j];
                        ++l;
                    }
                    ++i;
                }
                ++j;
            }
            double[][] S = new double[2][2];
            S[0][0] = A[this.n - 2][this.n - 2];
            S[1][1] = A[this.n - 1][this.n - 1];
            double d = A[this.n - 1][this.n - 2];
            S[0][1] = d;
            S[1][0] = d;
            Matrix MS = new Matrix(S);
            double[] evs = MS.eig().getRealEigenvalues();
            double lambda_lo = evs[0];
            delta = Math.max(0.0, Math.max(-lambda_lo + Math.max(tau * ((lambda_hi = evs[1]) - lambda_lo) / (1.0 - tau), tau_mod * gamma), delta_prev));
            if (delta > 0.0) {
                double[] dArray = A[this.n - 2];
                int n = this.n - 2;
                dArray[n] = dArray[n] + delta;
                double[] dArray2 = A[this.n - 1];
                int n2 = this.n - 1;
                dArray2[n2] = dArray2[n2] + delta;
                delta_prev = delta;
            }
            L[this.n - 2][this.n - 2] = Math.sqrt(A[this.n - 2][this.n - 2]);
            L[this.n - 1][this.n - 2] = A[this.n - 1][this.n - 2] / L[this.n - 2][this.n - 2];
            L[this.n - 1][this.n - 1] = Math.sqrt(A[this.n - 1][this.n - 1] - L[this.n - 1][this.n - 2] * L[this.n - 1][this.n - 2]);
            double d2 = delta;
            this.E_Diagonal[this.n - 1] = d2;
            this.E_Diagonal[this.n - 2] = d2;
        }
        this.L = ML;
        this.ENorm = delta_prev;
    }

    private void buildPTR() {
        this.PTR = Matrix.identity(this.n, this.n);
        double[][] PTRA = this.PTR.getArray();
        int k = this.pivotTransformQueue.size();
        while (k-- > 0) {
            PivotTransform pt = this.pivotTransformQueue.removeLast();
            double[] temp_row = PTRA[pt.pos1];
            PTRA[pt.pos1] = PTRA[pt.pos2];
            PTRA[pt.pos2] = temp_row;
        }
    }

    public Matrix getL() {
        return this.L;
    }

    public Matrix getPTR() {
        if (this.PTR == null) {
            this.buildPTR();
        }
        return this.PTR;
    }

    public double[] getE_Diagonal() {
        return this.E_Diagonal;
    }

    public Matrix getE() {
        if (this.E == null) {
            Matrix diagVector = new Matrix((double[])this.E_Diagonal.clone(), this.n);
            if (this.PTR == null) {
                this.buildPTR();
            }
            diagVector = this.PTR.times(diagVector);
            this.E = new Matrix(this.n, this.n, 0.0);
            int i = 0;
            while (i < this.n) {
                this.E.set(i, i, diagVector.get(i, 0));
                ++i;
            }
        }
        return this.E;
    }

    public double getENorm() {
        return this.ENorm;
    }

    public double getDetL() {
        if (this.detL == 0.0) {
            double det = 1.0;
            int i = 0;
            while (i < this.L.getRowDimension()) {
                det *= this.L.get(i, i);
                ++i;
            }
            this.detL = det;
        }
        return this.detL;
    }

    public double getDetA() {
        return this.getDetL() * this.getDetL();
    }

    private static class PivotTransform {
        int pos1;
        int pos2;

        PivotTransform(int pos1, int pos2) {
            this.pos1 = pos1;
            this.pos2 = pos2;
        }
    }
}

