/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM;

import edu.udo.cs.myRVM.Kernel.KernelBasisFunction;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Model {
    private KernelBasisFunction[] kernels;
    private double[] weights;
    private boolean bias;
    private boolean regression;

    private Model() {
    }

    public Model(double[] weights, KernelBasisFunction[] kernels, boolean bias, boolean regression) {
        this.kernels = kernels;
        this.weights = weights;
        this.bias = bias;
        this.regression = regression;
    }

    public int getNumberOfRelevanceVectors() {
        return this.weights.length;
    }

    public double getWeight(int index) {
        return this.weights[index];
    }

    public double applyToVector(double[] vector) {
        double prediction;
        int j;
        if (this.bias) {
            j = 1;
            prediction = this.weights[0];
        } else {
            j = 0;
            prediction = 0.0;
        }
        while (j < this.weights.length) {
            prediction += this.weights[j] * this.kernels[j].eval(vector);
            ++j;
        }
        return prediction;
    }

    public double[] apply(double[][] inputVectors) {
        double[] prediction = new double[inputVectors.length];
        int i = 0;
        while (i < inputVectors.length) {
            prediction[i] = this.applyToVector(inputVectors[i]);
            if (!this.regression) {
                prediction[i] = prediction[i] > 0.0 ? 1.0 : 0.0;
            }
            ++i;
        }
        return prediction;
    }

    public static Model readModel(ObjectInputStream in) throws IOException {
        Model model = new Model();
        int numVectors = in.readInt();
        model.kernels = new KernelBasisFunction[numVectors];
        model.weights = new double[numVectors];
        int i = 0;
        while (i < model.weights.length) {
            model.weights[i] = in.readDouble();
            model.kernels[i] = KernelBasisFunction.readKernel(in);
            ++i;
        }
        model.bias = in.readBoolean();
        return model;
    }

    public void writeModel(ObjectOutputStream out) throws IOException {
        out.writeInt(this.weights.length);
        int i = 0;
        while (i < this.weights.length) {
            out.writeDouble(this.weights[i]);
            this.kernels[i].writeKernel(out);
            ++i;
        }
        out.writeBoolean(this.bias);
    }

    public double norm_l2(double[] vector) {
        double result = 0.0;
        int i = 0;
        while (i < vector.length) {
            result += vector[i] * vector[i];
            ++i;
        }
        return Math.sqrt(result);
    }

    public double calculate(double[] att) {
        double noise = 0.1;
        double norm = this.norm_l2(att);
        return Math.sin(norm) / norm + noise * RandomGenerator.getRandomGenerator(0).nextDouble() - 0.5 * noise;
    }

    public void dumpToFile() {
        String path = "/windows/C/Diplom/figs/rvm_results/test-2d/";
        int n = 100;
        double scaleX = 10.0;
        double scaleY = 10.0;
        double[] x = new double[n];
        double[] y = new double[n];
        double[][] label = new double[n][n];
        double[][] pred = new double[n][n];
        double[][] RV = new double[this.weights.length][4];
        File xFile = new File(String.valueOf(path) + "X");
        File yFile = new File(String.valueOf(path) + "Y");
        File labelFile = new File(String.valueOf(path) + "Label");
        File predFile = new File(String.valueOf(path) + "Prediction");
        File RVFile = new File(String.valueOf(path) + "RV");
        double[] point = new double[2];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double currentX = -1.0 * scaleX + 2.0 / (double)n * scaleX * (double)j;
                double currentY = -1.0 * scaleY + 2.0 / (double)n * scaleY * (double)i;
                x[j] = currentX;
                y[i] = currentY;
                point[0] = currentX;
                point[1] = currentY;
                label[i][j] = this.calculate(point);
                pred[i][j] = this.applyToVector(point);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.weights.length) {
            if (i == 0 && this.bias) {
                point[0] = 0.0;
                RV[0][0] = 0.0;
                point[1] = 0.0;
                RV[0][1] = 0.0;
                RV[0][2] = this.calculate(point);
                RV[0][3] = this.applyToVector(point);
            } else {
                point = this.kernels[i].getBasisVector();
                RV[i][0] = point[0];
                RV[i][1] = point[1];
                RV[i][2] = this.calculate(point);
                RV[i][3] = this.applyToVector(point);
            }
            ++i;
        }
        try {
            FileWriter labelOut = new FileWriter(labelFile);
            FileWriter predOut = new FileWriter(predFile);
            int i2 = 0;
            while (i2 < n) {
                int j = 0;
                while (j < n) {
                    labelOut.write(String.valueOf(new Double(label[i2][j]).toString()) + " ");
                    predOut.write(String.valueOf(new Double(pred[i2][j]).toString()) + " ");
                    ++j;
                }
                labelOut.write(Tools.getLineSeparator());
                predOut.write(Tools.getLineSeparator());
                ++i2;
            }
            labelOut.close();
            predOut.close();
            FileWriter xOut = new FileWriter(xFile);
            FileWriter yOut = new FileWriter(yFile);
            int i3 = 0;
            while (i3 < n) {
                xOut.write(String.valueOf(new Double(x[i3]).toString()) + Tools.getLineSeparator());
                yOut.write(String.valueOf(new Double(y[i3]).toString()) + Tools.getLineSeparator());
                ++i3;
            }
            xOut.close();
            yOut.close();
            FileWriter RVOut = new FileWriter(RVFile);
            int i4 = 0;
            while (i4 < this.weights.length) {
                int j = 0;
                while (j < RV[i4].length) {
                    RVOut.write(String.valueOf(new Double(RV[i4][j]).toString()) + " ");
                    ++j;
                }
                RVOut.write(Tools.getLineSeparator());
                ++i4;
            }
            RVOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

