/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.myRVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelSigmoid
extends Kernel {
    private double a = 1.0;
    private double b = 0.0;

    public KernelSigmoid(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public KernelSigmoid() {
    }

    public double eval(double[] x, double[] y) {
        double prod = 0.0;
        int i = 0;
        while (i < x.length) {
            prod += x[i] * y[i];
            ++i;
        }
        prod = this.a * prod + this.b;
        double e1 = Math.exp(prod);
        double e2 = Math.exp(-prod);
        return (e1 - e2) / (e1 + e2);
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.a);
        out.writeDouble(this.b);
    }

    public void readKernelData(ObjectInputStream in) throws IOException {
        this.a = in.readDouble();
        this.b = in.readDouble();
    }

    public String toString() {
        return "sigmoid kernel [a = " + this.a + ", b = " + this.b + "]";
    }
}

