/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.myRVM.Kernel.KernelRadial;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelPoly
extends KernelRadial {
    protected double degree = 2.0;
    protected double bias = 0.0;

    public KernelPoly() {
    }

    public KernelPoly(double lengthScale, double bias, double degree) {
        super(lengthScale);
        this.bias = bias;
        this.degree = degree;
    }

    public double eval(double[] x, double[] y) {
        double result = 0.0;
        int i = 0;
        while (i < x.length) {
            result += x[i] * y[i];
            ++i;
        }
        result = Math.pow(Math.pow(this.lengthScale, -2.0) * result + this.bias, this.degree);
        return result;
    }

    public String toString() {
        return "poly kernel [lengthScale = " + this.lengthScale + ", bias = " + this.bias + ", order = " + this.degree + "]";
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        super.writeKernelData(out);
        out.writeDouble(this.bias);
        out.writeDouble(this.degree);
    }

    public void readKernelData(ObjectInputStream in) throws IOException {
        super.readKernelData(in);
        this.bias = in.readDouble();
        this.degree = in.readDouble();
    }
}

