/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.myRVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelMultiquadric
extends Kernel {
    private double sigma = 1.0;
    private double shift = 1.0;

    public KernelMultiquadric(double sigma, double shift) {
        this.sigma = sigma;
        this.shift = shift;
    }

    public KernelMultiquadric() {
    }

    public double eval(double[] x, double[] y) {
        return Math.sqrt(this.norm2(x, y) / this.sigma + this.shift * this.shift);
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma);
        out.writeDouble(this.shift);
    }

    public void readKernelData(ObjectInputStream in) throws IOException {
        this.sigma = in.readDouble();
        this.shift = in.readDouble();
    }

    public String toString() {
        return "multiquadric kernel [sigma = " + this.sigma + ", shift = " + this.shift + "]";
    }
}

