/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.myRVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelEpanechnikov
extends Kernel {
    private double sigma = 1.0;
    private double degree = 1.0;

    public KernelEpanechnikov(double sigma, double degree) {
        this.sigma = sigma;
        this.degree = degree;
    }

    public KernelEpanechnikov() {
    }

    public double eval(double[] x, double[] y) {
        double expression = this.norm2(x, y) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma);
        out.writeDouble(this.degree);
    }

    public void readKernelData(ObjectInputStream in) throws IOException {
        this.sigma = in.readDouble();
        this.degree = in.readDouble();
    }

    public String toString() {
        return "epanechnikov kernel [sigma = " + this.sigma + ", degree = " + this.degree + "]";
    }
}

