/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.myRVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class KernelBasisFunction {
    protected int dim = 0;
    protected double[] y = null;
    protected Kernel kernel = null;

    private KernelBasisFunction() {
    }

    public KernelBasisFunction(Kernel kernel, double[] y_vector) {
        this.y = y_vector;
        this.dim = this.y.length;
        this.kernel = kernel;
    }

    public KernelBasisFunction(Kernel kernel) {
        this.kernel = kernel;
    }

    public double eval(double[] x) {
        return this.kernel.eval(x, this.y);
    }

    public double[] getBasisVector() {
        return this.y;
    }

    public void writeKernel(ObjectOutputStream out) throws IOException {
        out.writeInt(this.dim);
        int i = 0;
        while (i < this.dim) {
            out.writeDouble(this.y[i]);
            ++i;
        }
        this.kernel.writeKernel(out);
    }

    public static KernelBasisFunction readKernel(ObjectInputStream in) throws IOException {
        KernelBasisFunction kernelBasisFunction = new KernelBasisFunction();
        kernelBasisFunction.dim = in.readInt();
        kernelBasisFunction.y = new double[kernelBasisFunction.dim];
        int i = 0;
        while (i < kernelBasisFunction.dim) {
            kernelBasisFunction.y[i] = in.readDouble();
            ++i;
        }
        kernelBasisFunction.kernel = Kernel.readKernel(in);
        return kernelBasisFunction;
    }
}

