/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myRVM.Kernel;

import edu.udo.cs.yale.tools.Tools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Kernel {
    public abstract double eval(double[] var1, double[] var2);

    public abstract void writeKernelData(ObjectOutputStream var1) throws IOException;

    public abstract void readKernelData(ObjectInputStream var1) throws IOException;

    public double norm2(double[] x, double[] y) {
        double result = 0.0;
        int i = 0;
        while (i < x.length) {
            double diff = x[i] - y[i];
            result += diff * diff;
            ++i;
        }
        return result;
    }

    public final void writeKernel(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.getClass().getName());
        this.writeKernelData(out);
    }

    public static Kernel readKernel(ObjectInputStream in) throws IOException {
        String className = in.readUTF();
        Kernel kernel = null;
        try {
            kernel = (Kernel)Tools.classForName(className).newInstance();
        }
        catch (Exception e) {
            throw new IOException("Cannot read kernel: " + e.getMessage());
        }
        kernel.readKernelData(in);
        return kernel;
    }
}

