/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myKLR;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;

public class KLR
implements SVMInterface {
    protected Kernel kernel;
    protected ExampleSet examples;
    int n;
    double[] target;
    int N1;
    int N2;
    double[] alphas;
    double[] Hcache;
    boolean[] at_bound;
    int i_up;
    int i_low;
    double b;
    double b_up;
    double b_low;
    double tol = 0.001;
    double C = 1.0;
    double epsilon;
    double mu;
    int max_iterations = 100000;

    public KLR() {
    }

    public KLR(Operator paramOperator) throws UndefinedParameterError {
        this.C = paramOperator.getParameterAsDouble("C");
        this.tol = paramOperator.getParameterAsDouble("convergence_epsilon");
        this.max_iterations = paramOperator.getParameterAsInt("max_iterations");
    }

    public void init(Kernel new_kernel, ExampleSet new_examples) {
        this.kernel = new_kernel;
        this.examples = new_examples;
        this.target = this.examples.get_ys();
        this.alphas = this.examples.get_alphas();
        this.n = this.examples.count_examples();
        this.mu = this.epsilon = this.C * 1.0E-10;
        this.N1 = this.examples.count_pos_examples();
        this.N2 = this.n - this.N1;
    }

    final double dG(double alpha) {
        return Math.log(alpha / (this.C - alpha));
    }

    final double dPhi(double t, int i, int j, double ai, double aj, double Kii, double Kij, double Kjj) {
        double result = 0.0;
        double ydG = 0.0;
        if (this.target[i] > 0.0) {
            result = Kii - Kij;
            ydG = this.dG(ai + t) - this.dG(ai);
        } else {
            result = Kij - Kii;
            ydG = this.dG(ai) - this.dG(ai - t);
        }
        if (this.target[j] > 0.0) {
            result = Kjj - Kij;
            ydG -= this.dG(aj - t) - this.dG(aj);
        } else {
            result = Kij - Kjj;
            ydG -= this.dG(aj) - this.dG(aj + t);
        }
        result = t * (Kii - 2.0 * Kij + Kjj);
        result += ydG;
        return result += this.Hcache[i] - this.Hcache[j];
    }

    final double d2Phi(double t, int i, int j, double ai, double aj, double Kii, double Kij, double Kjj) {
        double atilde = this.target[i] > 0.0 ? ai + t : ai - t;
        double result = this.C / (atilde * (this.C - atilde));
        atilde = this.target[j] > 0.0 ? aj - t : aj + t;
        result += this.C / (atilde * (this.C - atilde));
        return result += Kii - 2.0 * Kij + Kjj;
    }

    protected boolean takeStep(int i, int j) {
        double Hj;
        double Hi;
        double t_tmp;
        double t_max;
        double t_min;
        double[] kernel_row_i = this.kernel.get_row(i);
        double[] kernel_row_j = this.kernel.get_row(j);
        double aio = this.alphas[i];
        double ajo = this.alphas[j];
        double yi = this.target[i];
        double yj = this.target[j];
        double Hio = this.Hcache[i];
        double Hjo = this.Hcache[j];
        double Kii = kernel_row_i[i];
        double Kij = kernel_row_i[j];
        double Kjj = kernel_row_j[j];
        int takestepFlag = 1;
        if (yi > 0.0) {
            t_min = this.mu / 2.0 - aio;
            t_max = this.C - this.mu / 2.0 - aio;
        } else {
            t_max = aio - this.mu / 2.0;
            t_min = aio - (this.C - this.mu / 2.0);
        }
        if (yj > 0.0) {
            t_tmp = ajo - this.mu / 2.0;
            if (t_tmp < t_max) {
                t_max = t_tmp;
            }
            if ((t_tmp = ajo - (this.C - this.mu / 2.0)) > t_min) {
                t_min = t_tmp;
            }
        } else {
            t_tmp = this.mu / 2.0 - ajo;
            if (t_tmp > t_min) {
                t_min = t_tmp;
            }
            if ((t_tmp = this.C - this.mu / 2.0 - ajo) < t_max) {
                t_max = t_tmp;
            }
        }
        if (t_max - t_min <= this.epsilon) {
            return false;
        }
        double t = 0.0;
        double the_dPhi = Hio - Hjo;
        double the_d2Phi = Kii - 2.0 * Kij + Kjj + this.C / (aio * (this.C - aio)) + this.C / (ajo * (this.C - ajo));
        double dPhi_left = 0.0;
        double d2Phi_left = 0.0;
        double dPhi_right = 0.0;
        double d2Phi_right = 0.0;
        double t_left = 0.0;
        double t_right = 0.0;
        if (the_dPhi > 0.0) {
            dPhi_left = this.dPhi(t_min, i, j, aio, ajo, Kii, Kij, Kjj);
            d2Phi_left = this.d2Phi(t_min, i, j, aio, ajo, Kii, Kij, Kjj);
            if (dPhi_left < 0.0) {
                t_left = t_min;
                t_right = t;
                dPhi_right = the_dPhi;
                d2Phi_right = the_d2Phi;
            } else {
                t = t_min;
                takestepFlag = 2;
            }
        } else if (the_dPhi < 0.0) {
            dPhi_right = this.dPhi(t_max, i, j, aio, ajo, Kii, Kij, Kjj);
            d2Phi_right = this.d2Phi(t_max, i, j, aio, ajo, Kii, Kij, Kjj);
            if (dPhi_right > 0.0) {
                t_left = t;
                t_right = t_max;
                dPhi_left = the_dPhi;
                d2Phi_left = the_d2Phi;
            } else {
                t = t_max;
                takestepFlag = 2;
            }
        } else {
            return false;
        }
        double ai = 0.0;
        double aj = 0.0;
        if (takestepFlag == 1) {
            double t0;
            if (Math.abs(dPhi_left) < Math.abs(dPhi_right)) {
                t0 = t_left;
                the_dPhi = dPhi_left;
                the_d2Phi = d2Phi_left;
            } else {
                t0 = t_right;
                the_dPhi = dPhi_right;
                the_d2Phi = d2Phi_right;
            }
            do {
                double dt;
                if ((t = t0 + (dt = -the_dPhi / the_d2Phi)) <= t_left || t >= t_right) {
                    t = (t_left + t_right) / 2.0;
                }
                ai = aio + t / yi;
                aj = ajo - t / yj;
                Hi = Hio + t * (Kii - Kij) + yi * (Math.log(ai / (this.C - ai)) - Math.log(aio / (this.C - aio)));
                Hj = Hjo + t * (Kij - Kjj) + yj * (Math.log(aj / (this.C - aj)) - Math.log(ajo / (this.C - ajo)));
                the_dPhi = Hi - Hj;
                the_d2Phi = Kii - 2.0 * Kij + Kjj + this.C / (ai * (this.C - ai)) + this.C / (aj * (this.C - aj));
                if (the_dPhi * dPhi_left > 0.0) {
                    t_left = t;
                    dPhi_left = the_dPhi;
                } else {
                    t_right = t;
                    dPhi_right = the_dPhi;
                }
                t0 = t;
            } while (Math.abs(the_dPhi) > 0.1 * this.tol && t_left + this.epsilon < t_right);
        } else if (takestepFlag == 2) {
            ai = aio + t / yi;
            aj = ajo - t / yj;
            Hi = Hio + t * (Kii - Kij) + yi * (Math.log(ai / (this.C - ai)) - Math.log(aio / (this.C - aio)));
            Hj = Hjo + t * (Kij - Kjj) + yj * (Math.log(aj / (this.C - aj)) - Math.log(ajo / (this.C - ajo)));
        }
        if (t == 0.0) {
            return false;
        }
        this.alphas[i] = ai;
        this.alphas[j] = aj;
        if (ai <= this.mu) {
            if (this.target[i] > 0.0 && this.target[j] > 0.0 || this.target[i] < 0.0 && this.target[j] < 0.0) {
                int n = j;
                this.alphas[n] = this.alphas[n] - (this.mu - this.alphas[i]);
            } else {
                int n = j;
                this.alphas[n] = this.alphas[n] + (this.mu - this.alphas[i]);
            }
            this.alphas[i] = this.mu;
            this.at_bound[i] = true;
        } else if (ai >= this.C - this.mu) {
            if (this.target[i] > 0.0 && this.target[j] > 0.0 || this.target[i] < 0.0 && this.target[j] < 0.0) {
                int n = j;
                this.alphas[n] = this.alphas[n] - (this.C - this.mu - this.alphas[i]);
            } else {
                int n = j;
                this.alphas[n] = this.alphas[n] + (this.C - this.mu - this.alphas[i]);
            }
            this.alphas[i] = this.C - this.mu;
            this.at_bound[i] = true;
        } else {
            this.at_bound[i] = false;
        }
        if (aj <= this.mu) {
            if (this.target[i] > 0.0 && this.target[j] > 0.0 || this.target[i] < 0.0 && this.target[j] < 0.0) {
                int n = i;
                this.alphas[n] = this.alphas[n] - (this.mu - this.alphas[j]);
            } else {
                int n = i;
                this.alphas[n] = this.alphas[n] + (this.mu - this.alphas[j]);
            }
            this.alphas[j] = this.mu;
            this.at_bound[j] = true;
        } else if (aj >= this.C - this.mu) {
            if (this.target[i] > 0.0 && this.target[j] > 0.0 || this.target[i] < 0.0 && this.target[j] < 0.0) {
                int n = i;
                this.alphas[n] = this.alphas[n] - (this.C - this.mu - this.alphas[j]);
            } else {
                int n = i;
                this.alphas[n] = this.alphas[n] + (this.C - this.mu - this.alphas[j]);
            }
            this.alphas[j] = this.C - this.mu;
            this.at_bound[j] = true;
        } else {
            this.at_bound[j] = false;
        }
        t = ((this.alphas[i] - aio) * yi + (ajo - this.alphas[j]) * yj) / 2.0;
        Hi = Hio + t * (Kii - Kij) + yi * (Math.log(this.alphas[i] / (this.C - this.alphas[i])) - Math.log(aio / (this.C - aio)));
        Hj = Hjo + t * (Kij - Kjj) + yj * (Math.log(this.alphas[j] / (this.C - this.alphas[j])) - Math.log(ajo / (this.C - ajo)));
        int k = 0;
        while (k < this.n) {
            int n = k;
            this.Hcache[n] = this.Hcache[n] + t * (kernel_row_i[k] - kernel_row_j[k]);
            ++k;
        }
        this.Hcache[i] = Hi;
        this.Hcache[j] = Hj;
        this.b_up = Double.NEGATIVE_INFINITY;
        this.b_low = Double.POSITIVE_INFINITY;
        this.i_up = 0;
        this.i_low = 0;
        int l = 0;
        while (l < this.n) {
            if (!this.at_bound[l]) {
                if (this.Hcache[l] > this.b_up) {
                    this.b_up = this.Hcache[l];
                    this.i_up = l;
                }
                if (this.Hcache[l] < this.b_low) {
                    this.b_low = this.Hcache[l];
                    this.i_low = l;
                }
            }
            ++l;
        }
        return true;
    }

    public void klr() {
        this.examples.clearAlphas();
        this.Hcache = new double[this.n];
        this.at_bound = new boolean[this.n];
        double alpha_pos = this.C / (double)this.N1;
        double alpha_neg = this.C / (double)this.N2;
        int i = 0;
        while (i < this.n) {
            this.alphas[i] = this.target[i] > 0.0 ? alpha_pos : alpha_neg;
            this.at_bound[i] = false;
            ++i;
        }
        this.b_up = Double.NEGATIVE_INFINITY;
        this.b_low = Double.POSITIVE_INFINITY;
        this.i_up = 0;
        this.i_low = 0;
        i = 0;
        while (i < this.n) {
            double sum_pos_K = 0.0;
            double sum_neg_K = 0.0;
            double[] kernel_row = this.kernel.get_row(i);
            int j = 0;
            while (j < this.n) {
                if (this.target[j] > 0.0) {
                    sum_pos_K += kernel_row[j];
                } else {
                    sum_neg_K += kernel_row[j];
                }
                ++j;
            }
            this.Hcache[i] = alpha_pos * sum_pos_K - alpha_neg * sum_neg_K + this.target[i] * this.dG(this.alphas[i]);
            if (this.Hcache[i] > this.b_up) {
                this.b_up = this.Hcache[i];
                this.i_up = i;
            }
            if (this.Hcache[i] < this.b_low) {
                this.b_low = this.Hcache[i];
                this.i_low = i;
            }
            ++i;
        }
        int it = this.max_iterations;
        while (true) {
            boolean Flag;
            if (2.0 * this.tol < this.b_up - this.b_low) {
                --it;
                Flag = this.takeStep(this.i_low, this.i_up);
                if (Flag) {
                    continue;
                }
            }
            int numChange = 0;
            i = 0;
            while (i < this.n) {
                if (this.at_bound[i]) {
                    double Hi = this.Hcache[i];
                    if (Math.abs(Hi - this.b_low) >= Math.abs(Hi - this.b_up)) {
                        --it;
                        Flag = this.takeStep(i, this.i_low);
                        if (!Flag) {
                            --it;
                            Flag = this.takeStep(i, this.i_up);
                        }
                    } else {
                        --it;
                        Flag = this.takeStep(i, this.i_up);
                        if (!Flag) {
                            --it;
                            Flag = this.takeStep(i, this.i_low);
                        }
                    }
                    if (!this.at_bound[i]) {
                        ++numChange;
                    }
                }
                ++i;
            }
            if (numChange == 0 || it <= 0) break;
        }
        this.b = (this.b_low + this.b_up) / 2.0;
    }

    public double predict(Example example) {
        double the_sum = this.examples.get_b();
        int i = 0;
        while (i < this.n) {
            double alpha = this.alphas[i];
            if (alpha != 0.0) {
                Example sv = this.examples.get_example(i);
                the_sum += this.alphas[i] * this.kernel.calculate_K(sv, example);
            }
            ++i;
        }
        the_sum = 1.0 / (1.0 + Math.exp(-the_sum));
        return the_sum;
    }

    public void predict(ExampleSet to_predict) {
        int size = to_predict.count_examples();
        int i = 0;
        while (i < size) {
            Example example = to_predict.get_example(i);
            double prediction = this.predict(example);
            to_predict.set_y(i, prediction);
            ++i;
        }
    }

    public void train() {
        this.klr();
        this.b = -this.b;
        this.examples.set_b(this.b);
        int i = 0;
        while (i < this.n) {
            if (this.target[i] < 0.0) {
                this.alphas[i] = -this.alphas[i];
            }
            ++i;
        }
    }

    public double[] getWeights() {
        int dim = this.examples.get_dim();
        int examples_total = this.examples.count_examples();
        double[] w = new double[dim];
        int j = 0;
        while (j < dim) {
            w[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < examples_total) {
            double[] x = this.examples.get_example(i).toDense(dim);
            double alpha = this.alphas[i];
            int j2 = 0;
            while (j2 < dim) {
                int n = j2;
                w[n] = w[n] + alpha * x[j2];
                ++j2;
            }
            ++i;
        }
        return w;
    }

    public double getB() {
        return this.examples.get_b();
    }
}

