/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.myGP;

import Jama.Matrix;
import edu.udo.cs.myRVM.Kernel.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Model {
    private Kernel kernel;
    private double[][] basisVectors;
    private Matrix C;
    private Matrix alpha;
    private Matrix Q;
    private boolean regression;
    private Matrix k;
    private int d;
    private int inputDim;

    private Model() {
    }

    public Model(Kernel kernel, double[][] basisVectors, Matrix alpha, Matrix C, Matrix Q, int d, boolean regression) {
        this.kernel = kernel;
        this.basisVectors = basisVectors;
        this.alpha = alpha;
        this.C = C;
        this.Q = Q;
        this.regression = regression;
        this.d = d;
        this.inputDim = basisVectors[0].length;
        this.k = new Matrix(d, 1);
    }

    public int getNumberOfBasisVectors() {
        return this.basisVectors.length;
    }

    public int getInputDim() {
        return this.inputDim;
    }

    public double[] getBasisVector(int i) {
        return this.basisVectors[i];
    }

    public double getBasisVectorValue(int i, int j) {
        return this.basisVectors[i][j];
    }

    private double scalarProduct(double[][] x, double[][] y, int d) {
        double result = 0.0;
        int i = 0;
        while (i < d) {
            result += x[i][0] * y[i][0];
            ++i;
        }
        return result;
    }

    public double applyToVector(double[] x_new) {
        double m = 0.0;
        double prediction = 0.0;
        int j = 0;
        while (j < this.d) {
            this.k.getArray()[j][0] = this.kernel.eval(this.basisVectors[j], x_new);
            ++j;
        }
        prediction = m = this.scalarProduct(this.k.getArray(), this.alpha.getArray(), this.d);
        return prediction;
    }

    public double[] apply(double[][] inputVectors) throws Exception {
        double[] prediction = new double[inputVectors.length];
        int i = 0;
        while (i < inputVectors.length) {
            prediction[i] = this.applyToVector(inputVectors[i]);
            if (!this.regression) {
                prediction[i] = prediction[i] > 0.0 ? 1.0 : 0.0;
            }
            ++i;
        }
        return prediction;
    }

    private static Matrix readMatrix(ObjectInputStream in) throws IOException {
        int m = in.readInt();
        int n = in.readInt();
        Matrix matrix = new Matrix(m, n);
        double[][] matrixAsArray = matrix.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                matrixAsArray[i][j] = in.readDouble();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    private void writeMatrix(ObjectOutputStream out, Matrix matrix) throws IOException {
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        double[][] matrixAsArray = matrix.getArray();
        out.writeInt(m);
        out.writeInt(n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                out.writeDouble(matrixAsArray[i][j]);
                ++j;
            }
            ++i;
        }
    }

    private static double[] readDoubleArray(ObjectInputStream in, int length) throws IOException {
        double[] array = new double[length];
        int i = 0;
        while (i < length) {
            array[i] = in.readDouble();
            ++i;
        }
        return array;
    }

    private void writeDoubleArray(ObjectOutputStream out, double[] array) throws IOException {
        int i = 0;
        while (i < array.length) {
            out.writeDouble(array[i]);
            ++i;
        }
    }

    public static Model readModel(ObjectInputStream in) throws IOException {
        Model model = new Model();
        model.d = in.readInt();
        model.inputDim = in.readInt();
        model.kernel = Kernel.readKernel(in);
        model.basisVectors = new double[model.d][model.inputDim];
        int i = 0;
        while (i < model.d) {
            model.basisVectors[i] = Model.readDoubleArray(in, model.inputDim);
            ++i;
        }
        model.alpha = Model.readMatrix(in);
        model.C = Model.readMatrix(in);
        model.Q = Model.readMatrix(in);
        model.k = new Matrix(model.d, 1);
        return model;
    }

    public void writeModel(ObjectOutputStream out) throws IOException {
        out.writeInt(this.d);
        out.writeInt(this.inputDim);
        this.kernel.writeKernel(out);
        int i = 0;
        while (i < this.d) {
            this.writeDoubleArray(out, this.basisVectors[i]);
            ++i;
        }
        this.writeMatrix(out, this.alpha);
        this.writeMatrix(out, this.C);
        this.writeMatrix(out, this.Q);
    }
}

