/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Random;
import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.engine.RbfGaussianLayer;
import org.joone.engine.RbfGaussianParameters;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;

public class RbfRandomCenterSelector
extends ConverterPlugIn {
    private static final ILogger log = LoggerFactory.getLogger(RbfRandomCenterSelector.class);
    private RbfGaussianLayer theRbfGaussianLayer;
    private Vector thePatterns = null;

    public RbfRandomCenterSelector(RbfGaussianLayer aRbfGaussianLayer) {
        this.theRbfGaussianLayer = aRbfGaussianLayer;
        this.setAdvancedSerieSelector("1");
    }

    protected boolean convert(int serie) {
        if (this.thePatterns == null) {
            this.thePatterns = this.getInputVector();
        }
        return false;
    }

    public RbfGaussianParameters[] getGaussianParameters() {
        if (this.thePatterns.size() < this.theRbfGaussianLayer.getRows()) {
            log.warn("There are more neurons in RBF layer than training patterns -> not all nodes in RBF layer will be assigned a unique center.");
        }
        int[] myCenters = new int[this.theRbfGaussianLayer.getRows()];
        Random random = new Random(2005L);
        for (int i = 0; i < this.theRbfGaussianLayer.getRows(); ++i) {
            int myCenter = (int)(random.nextDouble() * (double)this.thePatterns.size());
            if (i < this.thePatterns.size()) {
                boolean myNonSelected = true;
                do {
                    if (!myNonSelected) {
                        myCenter = (int)(random.nextDouble() * (double)this.thePatterns.size());
                        myNonSelected = true;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (myCenters[j] != myCenter) continue;
                        myNonSelected = false;
                    }
                } while (!myNonSelected);
            }
            myCenters[i] = myCenter;
        }
        double myD = this.getMaxDistance(this.thePatterns, myCenters);
        double myStdDeviation = myD / Math.sqrt(2 * this.theRbfGaussianLayer.getRows());
        RbfGaussianParameters[] myParameters = new RbfGaussianParameters[this.theRbfGaussianLayer.getRows()];
        for (int i = 0; i < this.theRbfGaussianLayer.getRows(); ++i) {
            double[] myCenter = (double[])((Pattern)this.thePatterns.get(myCenters[i])).getArray().clone();
            myParameters[i] = new RbfGaussianParameters(myCenter, myStdDeviation);
        }
        return myParameters;
    }

    protected double getMaxDistance(Vector aPatterns, int[] anIndexes) {
        double myMax = -1.0;
        for (int i = 0; i < anIndexes.length - 1; ++i) {
            for (int j = i + 1; j < anIndexes.length; ++j) {
                double myDistance = this.getDistance((Pattern)aPatterns.get(anIndexes[i]), (Pattern)aPatterns.get(anIndexes[j]));
                if (!(myDistance > myMax)) continue;
                myMax = myDistance;
            }
        }
        return myMax;
    }

    protected double getDistance(Pattern aCenter1, Pattern aCenter2) {
        double myDistance = 0.0;
        for (int i = 0; i < aCenter1.getArray().length; ++i) {
            double myDiff = aCenter1.getArray()[i] - aCenter2.getArray()[i];
            myDistance += myDiff * myDiff;
        }
        return Math.sqrt(myDistance);
    }
}

