/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.util.ConverterPlugIn;

public class MinMaxExtractorPlugIn
extends ConverterPlugIn {
    private final double MIN_VALUE = 0.05;
    private final double MAX_VALUE = 0.95;
    private final double MID_VALUE = 0.49999999999999994;
    private double minPerc = 0.01;
    private static final long serialVersionUID = 6835532403570359948L;

    protected boolean convert(int serie) {
        boolean up;
        boolean retValue = false;
        int pf = 0;
        PointValue lastInserted = null;
        Vector<PointValue> changePoints = new Vector<PointValue>();
        PointValue pMax = new PointValue(0, this.getValuePoint(0, serie));
        PointValue pMin = new PointValue(0, this.getValuePoint(0, serie));
        PointValue pCur = new PointValue();
        int s = this.getInputVector().size();
        if (s > 1) {
            up = this.getValuePoint(1, serie) > pMax.value;
        } else {
            return false;
        }
        while (pf < s - 1) {
            PointValue lastInserting;
            if (up) {
                pCur.point = pf;
                pCur.value = this.getValuePoint(pf, serie);
                pf = this.findMax(pCur, serie);
                if (!pMin.equal(lastInserted) && this.minPerc(this.getValuePoint(pf, serie), pMin.value)) {
                    lastInserting = new PointValue(pMin.point, 0.05);
                    changePoints.addElement(lastInserting);
                    this.writeMidPoints(lastInserted, lastInserting, serie);
                    retValue = true;
                    lastInserted = new PointValue(lastInserting);
                    pMax.point = pf;
                    pMax.value = this.getValuePoint(pf, serie);
                }
                if (pMax.value < this.getValuePoint(pf, serie)) {
                    pMax.point = pf;
                    pMax.value = this.getValuePoint(pf, serie);
                }
            }
            up = false;
            pCur.point = pf;
            pCur.value = this.getValuePoint(pf, serie);
            pf = this.findMin(pCur, serie);
            if (!pMax.equal(lastInserted) && this.minPerc(this.getValuePoint(pf, serie), pMax.value)) {
                lastInserting = new PointValue(pMax.point, 0.95);
                changePoints.addElement(lastInserting);
                this.writeMidPoints(lastInserted, lastInserting, serie);
                retValue = true;
                lastInserted = new PointValue(lastInserting);
                pMin.point = pf;
                pMin.value = this.getValuePoint(pf, serie);
            }
            if (pMin.value > this.getValuePoint(pf, serie)) {
                pMin.point = pf;
                pMin.value = this.getValuePoint(pf, serie);
            }
            up = true;
        }
        if (lastInserted.point < s - 1) {
            this.writeMidPoints(lastInserted, new PointValue(s - 1, 0.49999999999999994), serie);
            Pattern currPE = (Pattern)this.getInputVector().elementAt(s - 1);
            currPE.setValue(serie, 0.49999999999999994);
            retValue = true;
        } else {
            Pattern currPE = (Pattern)this.getInputVector().elementAt(s - 1);
            currPE.setValue(serie, lastInserted.value);
            retValue = true;
        }
        return retValue;
    }

    private int findMax(PointValue pInit, int serie) {
        int i;
        int s = this.getInputVector().size();
        double lastValue = pInit.value;
        for (i = pInit.point + 1; i < s && this.getValuePoint(i, serie) >= lastValue; ++i) {
            lastValue = this.getValuePoint(i, serie);
        }
        return --i;
    }

    private int findMin(PointValue pInit, int serie) {
        int i;
        int s = this.getInputVector().size();
        double lastValue = pInit.value;
        for (i = pInit.point + 1; i < s && this.getValuePoint(i, serie) <= lastValue; ++i) {
            lastValue = this.getValuePoint(i, serie);
        }
        return --i;
    }

    public double getMinChangePercentage() {
        return this.minPerc;
    }

    private boolean minPerc(double last, double first) {
        double perc = (last - first) / first;
        if (perc < 0.0) {
            perc *= -1.0;
        }
        return !(perc < this.minPerc);
    }

    public void setMinChangePercentage(double newMinPerc) {
        if (this.minPerc != newMinPerc) {
            this.minPerc = newMinPerc;
            super.fireDataChanged();
        }
    }

    private void writeMidPoints(PointValue pointA, PointValue pointB, int serie) {
        double vmax;
        double vmin;
        double rmax;
        double rmin;
        double vi;
        int i;
        if (pointA == null) {
            i = 0;
            vi = 0.49999999999999994;
        } else {
            i = pointA.point;
            vi = pointA.value;
        }
        if (vi < pointB.value) {
            rmin = vi;
            rmax = pointB.value;
        } else {
            rmax = vi;
            rmin = pointB.value;
        }
        if (this.getValuePoint(i, serie) < this.getValuePoint(pointB.point, serie)) {
            vmin = this.getValuePoint(i, serie);
            vmax = this.getValuePoint(pointB.point, serie);
        } else {
            vmax = this.getValuePoint(i, serie);
            vmin = this.getValuePoint(pointB.point, serie);
        }
        double rdif = rmax - rmin;
        double vdif = vmax - vmin;
        while (i < pointB.point) {
            vi = (this.getValuePoint(i, serie) - vmin) / vdif;
            vi = vi * rdif + rmin;
            Pattern currPE = (Pattern)this.getInputVector().elementAt(i);
            currPE.setValue(serie, vi);
            ++i;
        }
    }

    class PointValue {
        double value;
        int point;

        PointValue() {
        }

        PointValue(PointValue c) {
            this.value = c.value;
            this.point = c.point;
        }

        PointValue(int p, double v) {
            this.value = v;
            this.point = p;
        }

        boolean equal(PointValue compare) {
            if (compare == null) {
                return false;
            }
            return compare.point == this.point;
        }
    }
}

