/*
 * Decompiled with CFR 0.152.
 */
package org.joone.script;

import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class JooneGroovyScript {
    private static final ILogger log = LoggerFactory.getLogger(JooneGroovyScript.class);
    private static final String GROOVY_IMPORT_PREFIX = "import org.joone.engine.*\nimport org.joone.engine.learning.*\nimport org.joone.edit.*\nimport org.joone.util.*\nimport org.joone.net.*\nimport org.joone.io.*\nimport org.joone.script.*\n";
    private GroovyShell groovyShell;

    private GroovyShell getShell() {
        if (this.groovyShell == null) {
            this.groovyShell = new GroovyShell();
        }
        return this.groovyShell;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java org.joone.script.JooneGroovyScript <script_file>");
        } else {
            JooneGroovyScript jScript = new JooneGroovyScript();
            jScript.source(args[0]);
        }
    }

    public void source(String fileName) {
        try {
            this.getShell().run(new File(fileName), new String[0]);
        }
        catch (CompilationFailedException cfe) {
            log.error("CompilationFailedException thrown. Message is : " + cfe.getMessage(), cfe);
        }
        catch (IOException ioe) {
            log.error("IOException thrown. Message is : " + ioe.getMessage(), ioe);
        }
    }

    public void eval(String script) {
        try {
            this.getShell().evaluate(GROOVY_IMPORT_PREFIX + script);
        }
        catch (CompilationFailedException cfe) {
            log.error("CompilationFailedException thrown. Message is : " + cfe.getMessage(), cfe);
        }
        catch (IOException ioe) {
            log.error("IOException thrown. Message is : " + ioe.getMessage(), ioe);
        }
    }

    public void set(String name, Object jObject) {
        this.getShell().setVariable(name, jObject);
    }
}

