/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.joone.engine.DirectSynapse;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.OutputSwitchSynapse;
import org.joone.engine.Pattern;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;

public class SimpleNeuralNet
implements Serializable,
Cloneable {
    private List layers = new ArrayList();
    private String name = "SimpleNeuralNet";
    private Layer inputLayer;
    private Layer outputLayer;
    private DirectSynapse in = null;
    private DirectSynapse out = null;
    public static final int INPUT_LAYER = 0;
    public static final int HIDDEN_LAYER = 1;
    public static final int OUTPUT_LAYER = 2;

    public SimpleNeuralNet(String aName) {
        this.name = aName;
    }

    public void start() {
        if (this.readyToStart()) {
            this.in = new DirectSynapse();
            this.in.setName(this.getName() + ": in synapse");
            this.addInputSynapse(this.in);
            this.out = new DirectSynapse();
            this.out.setName(this.getName() + ": out synapse");
            this.addOutputSynapse(this.out);
            try {
                for (int i = 0; i < this.layers.size(); ++i) {
                    Layer ly = (Layer)this.layers.get(i);
                    ly.start();
                }
            }
            catch (RuntimeException rte) {
                this.stop();
                throw rte;
            }
        } else {
            throw new RuntimeException("SimpleNeuralNet: The neural net is already running");
        }
    }

    private boolean readyToStart() {
        for (int i = 0; i < 100; ++i) {
            if (!this.isRunning()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    public void stop() {
        if (this.isRunning()) {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer ly = (Layer)this.layers.get(i);
                ly.stop();
            }
            this.removeInputSynapse(this.in);
            this.removeOutputSynapse(this.out);
            this.in = null;
            this.out = null;
        }
    }

    public Layer getInputLayer() {
        if (this.inputLayer != null) {
            return this.inputLayer;
        }
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            Vector inps = ly.getAllInputs();
            if (inps != null && inps.size() != 0) continue;
            this.inputLayer = ly;
            break;
        }
        return this.inputLayer;
    }

    public Layer getOutputLayer() {
        if (this.outputLayer != null) {
            return this.outputLayer;
        }
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            Vector outs = ly.getAllOutputs();
            if (outs == null || outs.size() == 0) {
                this.outputLayer = ly;
                break;
            }
            if (!this.checkOutputs(outs)) continue;
            this.outputLayer = ly;
            break;
        }
        return this.outputLayer;
    }

    protected boolean checkOutputs(Vector outs) {
        if (outs == null) {
            return true;
        }
        for (int x = 0; x < outs.size(); ++x) {
            OutputSwitchSynapse os;
            if (outs.elementAt(x) instanceof StreamOutputSynapse || outs.elementAt(x) instanceof TeachingSynapse || outs.elementAt(x) instanceof TeacherSynapse) {
                return true;
            }
            if (!(outs.elementAt(x) instanceof OutputSwitchSynapse) || !this.checkOutputs((os = (OutputSwitchSynapse)outs.elementAt(x)).getAllOutputs())) continue;
            return true;
        }
        return false;
    }

    public double[] getNextPattern(double[] input) {
        if (this.in == null || this.out == null) {
            throw new RuntimeException("SimpleNeuralNet: not started");
        }
        Pattern inPattern = new Pattern(input);
        inPattern.setCount(1);
        this.in.fwdPut(inPattern);
        return this.out.fwdGet().getArray();
    }

    public int getRows() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getRows();
        }
        return 0;
    }

    public void setRows(int p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setRows(p1);
        }
    }

    public void addNoise(double p1) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            ly.addNoise(p1);
        }
    }

    public void randomize(double amplitude) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            ly.randomize(amplitude);
        }
    }

    public Matrix getBias() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getBias();
        }
        return null;
    }

    public Vector getAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            return ly.getAllOutputs();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void removeOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeOutputSynapse(p1);
        }
    }

    public void setAllInputs(Vector p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setAllInputs(p1);
        }
    }

    public void removeAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeAllOutputs();
        }
    }

    public Vector getAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getAllInputs();
        }
        return null;
    }

    public void addOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.addOutputSynapse(p1);
        }
    }

    public void setBias(Matrix p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setBias(p1);
        }
    }

    public void removeInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeInputSynapse(p1);
        }
    }

    public void setName(String p1) {
        this.name = p1;
    }

    public void addInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.addInputSynapse(p1);
        }
    }

    public void setAllOutputs(Vector p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.setAllOutputs(p1);
        }
    }

    public void removeAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeAllInputs();
        }
    }

    public NeuralLayer copyInto(NeuralLayer p1) {
        return null;
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, 1);
    }

    public void addLayer(Layer layer, int tier) {
        if (!this.layers.contains(layer)) {
            this.layers.add(layer);
        }
        if (tier == 0) {
            this.inputLayer = layer;
        }
        if (tier == 2) {
            this.outputLayer = layer;
        }
    }

    public void removeLayer(Layer layer) {
        if (this.layers.contains(layer)) {
            this.layers.remove(layer);
        }
        if (layer == this.inputLayer) {
            this.inputLayer = null;
        } else if (layer == this.outputLayer) {
            this.outputLayer = null;
        }
    }

    public void resetInput() {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            Vector inputs = ly.getAllInputs();
            if (inputs == null) continue;
            for (int x = 0; x < inputs.size(); ++x) {
                InputPatternListener syn = (InputPatternListener)inputs.elementAt(x);
                if (!(syn instanceof StreamInputSynapse)) continue;
                ((StreamInputSynapse)syn).resetInput();
            }
        }
    }

    public Layer getLayer(String layerName) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            if (ly.getLayerName().compareToIgnoreCase(layerName) != 0) continue;
            return ly;
        }
        return null;
    }

    public List getLayers() {
        return this.layers;
    }

    public void setInputLayer(Layer newLayer) {
        this.inputLayer = newLayer;
    }

    public void setOutputLayer(Layer newLayer) {
        this.outputLayer = newLayer;
    }

    public boolean isRunning() {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.get(i);
            if (!ly.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void resetRecurrent() {
        double[] zeros = new double[this.in.getOutputDimension()];
        Arrays.fill(zeros, 0.0);
        for (int i = 0; i < this.layers.size() * 100; ++i) {
            this.getNextPattern(zeros);
        }
    }

    public SimpleNeuralNet cloneNet() {
        return (SimpleNeuralNet)this.clone();
    }

    public Object clone() {
        try {
            ByteArrayOutputStream f = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(this);
            s.flush();
            ByteArrayInputStream fi = new ByteArrayInputStream(f.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(fi);
            return oi.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

