/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.util.Vector;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class NeuralNetValidator
implements Runnable,
NeuralNetListener {
    private Vector listeners = new Vector();
    private NeuralNet nnet;
    private Thread myThread = null;
    private boolean stopped;
    private int currentCycle;
    private int totCycles;
    private boolean validation;
    private boolean useTrainingData = false;

    public NeuralNetValidator(NeuralNet nn) {
        this.nnet = nn;
    }

    public synchronized void addValidationListener(NeuralValidationListener newListener) {
        if (!this.listeners.contains(newListener)) {
            this.listeners.addElement(newListener);
        }
    }

    protected void validate() {
        this.totCycles = this.nnet.getMonitor().getTotCicles();
        this.currentCycle = this.nnet.getMonitor().getCurrentCicle();
        this.validation = this.nnet.getMonitor().isValidation();
        this.nnet.getMonitor().addNeuralNetListener(this);
        this.nnet.getMonitor().setLearning(false);
        this.nnet.getMonitor().setValidation(true);
        if (this.useTrainingData) {
            this.nnet.getMonitor().setTrainingDataForValidation(true);
        } else {
            this.nnet.getMonitor().setTrainingDataForValidation(false);
        }
        this.nnet.getMonitor().setTotCicles(1);
        this.nnet.start();
        this.stopped = false;
        this.nnet.getMonitor().Go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNetValidated() {
        Object[] list;
        double error = this.nnet.getMonitor().getGlobalError();
        this.nnet.getDescriptor().setValidationError(error);
        NeuralNetValidator neuralNetValidator = this;
        synchronized (neuralNetValidator) {
            list = this.listeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            NeuralValidationListener nvl = (NeuralValidationListener)list[i];
            nvl.netValidated(new NeuralValidationEvent(this.nnet));
        }
    }

    public void useTrainingData(boolean anUse) {
        this.useTrainingData = anUse;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "Validator");
            this.myThread.start();
        }
    }

    public void run() {
        this.validate();
        this.myThread = null;
    }

    public void netStopped(NeuralNetEvent e) {
        this.fireNetValidated();
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public NeuralNet getNeuralNet() {
        return this.nnet;
    }
}

