/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.NeuralLayer;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNetAttributes;
import org.joone.script.MacroInterface;

public class NeuralNet
implements NeuralLayer,
Serializable {
    private static final int MAJOR_RELEASE = 1;
    private static final int MINOR_RELEASE = 2;
    private static final int BUILD = 1;
    private static final String SUFFIX = "";
    private static final ILogger log = LoggerFactory.getLogger(NeuralNet.class);
    private Vector layers = new Vector();
    private String NetName;
    private Monitor mon = new Monitor();
    private Layer inputLayer;
    private Layer outputLayer;
    private TeachingSynapse teacher;
    private static final long serialVersionUID = 8351124226081783962L;
    public static final int INPUT_LAYER = 0;
    public static final int HIDDEN_LAYER = 1;
    public static final int OUTPUT_LAYER = 2;
    protected Vector listeners;
    private MacroInterface macroPlugin;
    private boolean scriptingEnabled = false;
    private NeuralNetAttributes descriptor = null;
    private Hashtable params;

    public void start() {
        this.stop(false);
        if (this.readyToStart()) {
            Layer ly = null;
            try {
                for (int i = 0; i < this.layers.size(); ++i) {
                    ly = (Layer)this.layers.elementAt(i);
                    ly.start();
                }
            }
            catch (RuntimeException rte) {
                this.stop();
                String msg = "RuntimeException was thrown while starting the neural network. Message is:" + rte.getMessage();
                log.error(msg, rte);
                throw new JooneRuntimeException(msg, rte);
            }
        } else {
            String msg = "NeuralNet: The neural net is already running";
            log.warn("NeuralNet: The neural net is already running");
            throw new JooneRuntimeException(msg);
        }
    }

    private boolean readyToStart() {
        for (int i = 0; i < 100; ++i) {
            if (!this.isRunning()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    public void join() {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.join();
        }
        if (this.teacher != null) {
            this.teacher.getTheLinearLayer().join();
        }
    }

    public void stop(boolean notify) {
        if (this.isRunning()) {
            Layer ly = null;
            for (int i = 0; i < this.layers.size(); ++i) {
                ly = (Layer)this.layers.elementAt(i);
                ly.stop();
            }
            if (this.teacher != null) {
                this.teacher.stop();
            }
            if (this.getMonitor() != null && notify) {
                new NetStoppedEventNotifier(this.getMonitor()).start();
            }
        }
    }

    public void stop() {
        this.stop(true);
    }

    protected int getNumOfstepCounters() {
        int count = 0;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.hasStepCounter()) continue;
            ++count;
        }
        if (this.teacher != null && this.teacher.getDesired() != null && this.teacher.getDesired().isStepCounter()) {
            ++count;
        }
        return count;
    }

    public Layer getInputLayer() {
        if (this.inputLayer != null) {
            return this.inputLayer;
        }
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.isInputLayer()) continue;
            this.inputLayer = ly;
            break;
        }
        return this.inputLayer;
    }

    public Layer getOutputLayer() {
        if (this.outputLayer != null) {
            return this.outputLayer;
        }
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.isOutputLayer()) continue;
            this.outputLayer = ly;
            break;
        }
        return this.outputLayer;
    }

    public int getRows() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getRows();
        }
        return 0;
    }

    public void setRows(int p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setRows(p1);
        }
    }

    public void addNoise(double p1) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.addNoise(p1);
        }
    }

    public void randomize(double amplitude) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.randomize(amplitude);
        }
    }

    public Matrix getBias() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getBias();
        }
        return null;
    }

    public Vector getAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            return ly.getAllOutputs();
        }
        return null;
    }

    public String getLayerName() {
        return this.NetName;
    }

    public void removeOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeOutputSynapse(p1);
        }
    }

    public void setAllInputs(Vector p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setAllInputs(p1);
        }
    }

    public void removeAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeAllOutputs();
        }
        this.setTeacher(null);
    }

    public Vector getAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getAllInputs();
        }
        return null;
    }

    public boolean addOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            return ly.addOutputSynapse(p1);
        }
        return false;
    }

    public void setBias(Matrix p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setBias(p1);
        }
    }

    public void removeInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeInputSynapse(p1);
        }
    }

    public void setLayerName(String p1) {
        this.NetName = p1;
    }

    public boolean addInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.addInputSynapse(p1);
        }
        return false;
    }

    public void setAllOutputs(Vector p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.setAllOutputs(p1);
        }
    }

    public void setMonitor(Monitor p1) {
        this.mon = p1;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.setMonitor(this.mon);
        }
        this.setScriptingEnabled(this.isScriptingEnabled());
        if (this.getTeacher() != null) {
            this.getTeacher().setMonitor(p1);
        }
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void removeAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeAllInputs();
        }
    }

    public NeuralLayer copyInto(NeuralLayer p1) {
        return null;
    }

    public void addTeacher(TeachingSynapse ts) {
        this.teacher = ts;
        this.teacher.setMonitor(this.mon);
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, 1);
    }

    public void addLayer(Layer layer, int tier) {
        if (!this.layers.contains(layer)) {
            layer.setMonitor(this.mon);
            this.layers.addElement(layer);
        }
        if (tier == 0) {
            this.inputLayer = layer;
        }
        if (tier == 2) {
            this.outputLayer = layer;
        }
    }

    public void removeLayer(Layer layer) {
        if (this.layers.contains(layer)) {
            this.layers.removeElement(layer);
            if (this.getMonitor() != null) {
                this.getMonitor().removeNeuralNetListener(layer);
            }
            if (layer == this.inputLayer) {
                this.inputLayer = null;
            } else if (layer == this.outputLayer) {
                this.outputLayer = null;
            }
        }
    }

    public void resetInput() {
        Layer ly = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            ly = (Layer)this.layers.elementAt(i);
            Vector inputs = ly.getAllInputs();
            if (inputs == null) continue;
            for (int x = 0; x < inputs.size(); ++x) {
                InputPatternListener syn = (InputPatternListener)inputs.elementAt(x);
                if (!(syn instanceof StreamInputSynapse)) continue;
                ((StreamInputSynapse)syn).resetInput();
            }
        }
        if (this.getTeacher() != null) {
            this.getTeacher().resetInput();
        }
    }

    public void addNeuralNetListener(NeuralNetListener listener) {
        if (this.getListeners().contains(listener)) {
            return;
        }
        this.listeners.addElement(listener);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(listener);
        }
    }

    public Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        return this.listeners;
    }

    public void removeNeuralNetListener(NeuralNetListener listener) {
        this.getListeners().removeElement(listener);
        if (this.getMonitor() != null) {
            this.getMonitor().removeNeuralNetListener(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Vector lst = this.getListeners();
        if (this.getMonitor() != null) {
            for (int i = 0; i < lst.size(); ++i) {
                this.getMonitor().addNeuralNetListener((NeuralNetListener)lst.elementAt(i));
            }
        }
        this.setMacroPlugin(this.macroPlugin);
    }

    public static String getVersion() {
        return "1.2.1";
    }

    public static Integer getNumericVersion() {
        return new Integer(1002001);
    }

    public Layer getLayer(String layerName) {
        Layer ly = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            ly = (Layer)this.layers.elementAt(i);
            if (ly.getLayerName().compareToIgnoreCase(layerName) != 0) continue;
            return ly;
        }
        return null;
    }

    public Vector getLayers() {
        return this.layers;
    }

    public void setLayers(Vector newlayers) {
        this.layers = newlayers;
    }

    public void setLayersList(ArrayList list) {
        this.setLayers(new Vector(list));
    }

    public void setTeacher(TeachingSynapse ts) {
        if (this.getMonitor() != null) {
            if (ts != null) {
                this.getMonitor().setSupervisioned(true);
            } else {
                this.getMonitor().setSupervisioned(false);
            }
        }
        this.teacher = ts;
    }

    public TeachingSynapse getTeacher() {
        return this.teacher;
    }

    public void setListeners(Vector listeners) {
    }

    public void setInputLayer(Layer newLayer) {
        this.inputLayer = newLayer;
    }

    public void setOutputLayer(Layer newLayer) {
        this.outputLayer = newLayer;
    }

    public NeuralNetAttributes getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new NeuralNetAttributes();
            this.descriptor.setNeuralNetName(this.getLayerName());
        }
        return this.descriptor;
    }

    public void setDescriptor(NeuralNetAttributes newdescriptor) {
        this.descriptor = newdescriptor;
    }

    public boolean isRunning() {
        Layer ly = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            ly = (Layer)this.layers.elementAt(i);
            if (!ly.isRunning()) continue;
            return true;
        }
        return this.teacher != null && this.teacher.getTheLinearLayer().isRunning();
    }

    public NeuralNet cloneNet() {
        NeuralNet newnet = null;
        try {
            ByteArrayOutputStream f = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(this);
            s.flush();
            ByteArrayInputStream fi = new ByteArrayInputStream(f.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(fi);
            newnet = (NeuralNet)oi.readObject();
        }
        catch (Exception ioe) {
            log.warn("IOException while cloning the Net. Message is : " + ioe.getMessage(), ioe);
        }
        return newnet;
    }

    public void removeAllListeners() {
        this.listeners = null;
        if (this.getMonitor() != null) {
            this.getMonitor().removeAllListeners();
        }
    }

    public void setScriptingEnabled(boolean enabled) {
        this.scriptingEnabled = enabled;
        if (enabled) {
            MacroInterface listener = this.getMacroPlugin();
            if (listener == null) {
                log.info("MacroPlugin not set: Impossible to enable the scripting");
            } else {
                this.addNeuralNetListener(this.getMacroPlugin());
            }
        } else if (this.macroPlugin != null) {
            this.removeNeuralNetListener(this.macroPlugin);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public MacroInterface getMacroPlugin() {
        return this.macroPlugin;
    }

    public void setMacroPlugin(MacroInterface macroPlugin) {
        if (macroPlugin != null) {
            this.removeNeuralNetListener(this.macroPlugin);
            if (this.scriptingEnabled) {
                this.addNeuralNetListener(macroPlugin);
            }
        }
        this.macroPlugin = macroPlugin;
        if (macroPlugin != null) {
            macroPlugin.set("jNet", this);
            macroPlugin.set("jMon", this.getMonitor());
        }
    }

    public Object getParam(String key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    public void setParam(String key, Object obj) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        if (this.params.containsKey(key)) {
            this.params.remove(key);
        }
        this.params.put(key, obj);
    }

    public String[] getKeys() {
        if (this.params == null) {
            return null;
        }
        String[] keys = new String[this.params.keySet().size()];
        Enumeration myEnum = this.params.keys();
        int i = 0;
        while (myEnum.hasMoreElements()) {
            keys[i] = (String)myEnum.nextElement();
            ++i;
        }
        return keys;
    }

    public TreeSet check() {
        TreeSet<NetCheck> checks = new TreeSet<NetCheck>();
        if (this.layers == null || this.layers.isEmpty()) {
            checks.add(new NetCheck(0, "The Neural Network doesn't contain any layer", this.mon));
            return checks;
        }
        if (this.getNumOfstepCounters() > 1) {
            checks.add(new NetCheck(0, "More than one InputSynapse having stepCounter set to true is present", this.mon));
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            checks.addAll(layer.check());
        }
        if (this.mon.getParent() == null) {
            if (this.teacher != null) {
                checks.addAll(this.teacher.check());
                if (this.mon != null && this.mon.isLearning() && !this.mon.isSupervisioned()) {
                    checks.add(new NetCheck(1, "Teacher is present: the supervised property should be set to true", this.mon));
                }
            } else if (this.mon != null && this.mon.isLearning() && this.mon.isSupervisioned()) {
                checks.add(new NetCheck(0, "Teacher not present: set to false the supervised property", this.mon));
            }
        }
        if (this.mon != null) {
            checks.addAll(this.mon.check());
        }
        return checks;
    }
}

