/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import org.joone.engine.InputPatternListener;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;

public class NetCheck
implements Comparable {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    private int severity;
    private String message;
    private Object object;

    public NetCheck(int severityArg, String messageArg, Object objectArg) {
        this.severity = severityArg;
        this.message = messageArg;
        this.object = objectArg;
    }

    public String toString() {
        String className = this.object.getClass().getName();
        className = className.substring(1 + className.lastIndexOf("."));
        String instanceName = this.object instanceof NeuralLayer ? ((NeuralLayer)this.object).getLayerName() : (this.object instanceof InputPatternListener ? ((InputPatternListener)this.object).getName() : (this.object instanceof OutputPatternListener ? ((OutputPatternListener)this.object).getName() : (this.object instanceof Monitor ? "Monitor" : this.object.toString())));
        StringBuffer checkMessage = new StringBuffer();
        if (this.severity == 0) {
            checkMessage.append("Error - ");
        } else if (this.severity == 1) {
            checkMessage.append("Warning - ");
        }
        checkMessage.append(className);
        checkMessage.append(" - ");
        if (instanceName != null && !instanceName.trim().equals("")) {
            checkMessage.append(instanceName);
            checkMessage.append(" - ");
        }
        checkMessage.append(this.message);
        return checkMessage.toString();
    }

    public boolean isWarning() {
        return this.severity == 1;
    }

    public boolean isError() {
        return this.severity == 0;
    }

    public int compareTo(Object o) {
        if (o instanceof NetCheck) {
            NetCheck nc = (NetCheck)o;
            return this.toString().compareTo(nc.toString());
        }
        return 0;
    }
}

