/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class YahooFinanceInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(YahooFinanceInputSynapse.class);
    String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    String[] frequency = new String[]{"Daily", "Weekly", "Monthly"};
    String[] freq_conv = new String[]{"d", "w", "m"};
    String Symbol = new String("");
    DateFormat date_formater = DateFormat.getDateInstance(2);
    Calendar CalendarStart = Calendar.getInstance();
    Calendar CalendarEnd = Calendar.getInstance();
    String DateStart = new String(this.date_formater.format(this.CalendarStart.getTime()));
    String DateEnd = new String(this.date_formater.format(this.CalendarEnd.getTime()));
    String Period = new String("Daily");
    private Vector[] StockData = new Vector[6];
    private Vector StockDates = new Vector();
    String[] ColumnNames = new String[]{"Date", "Open", "High", "Low", "Close", "Volume", "Adj. Close"};
    static final long serialVersionUID = 1301769209320717393L;

    public String getSymbol() {
        return this.Symbol;
    }

    public String getDateStart() {
        return this.DateStart;
    }

    public String getDateEnd() {
        return this.DateEnd;
    }

    public String getPeriod() {
        return this.Period;
    }

    public Vector getStockDates() {
        return this.StockDates;
    }

    public Vector[] getStockData() {
        return this.StockData;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObjectBase(in);
        if (in.getClass().getName().indexOf("xstream") == -1) {
            this.Symbol = (String)in.readObject();
            this.DateStart = (String)in.readObject();
            this.DateEnd = (String)in.readObject();
            this.Period = (String)in.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.initInputStream();
        }
    }

    public void setSymbol(String newSymbol) {
        if (!this.Symbol.equals(newSymbol)) {
            this.Symbol = newSymbol;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setDateStart(String newDateStart) {
        if (!this.DateStart.equals(newDateStart)) {
            this.DateStart = newDateStart;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setDateEnd(String newDateEnd) {
        if (!this.DateEnd.equals(newDateEnd)) {
            this.DateEnd = newDateEnd;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setPeriod(String newPeriod) {
        if (!this.Period.equals(newPeriod)) {
            this.Period = newPeriod;
            this.resetInput();
            this.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObjectBase(out);
        if (out.getClass().getName().indexOf("xstream") == -1) {
            out.writeObject(this.Symbol);
            out.writeObject(this.DateStart);
            out.writeObject(this.DateEnd);
            out.writeObject(this.Period);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        block13: {
            String final_patterns = new String("");
            int start = 0;
            String myUrl = new String("");
            boolean AddedData = false;
            boolean GotData = false;
            String cperiod = "d";
            for (int i = 0; i < this.frequency.length; ++i) {
                if (!this.Period.equals(this.frequency[i])) continue;
                cperiod = this.freq_conv[i];
            }
            this.StockData = null;
            this.StockDates = null;
            if (this.Symbol != null && !this.Symbol.equals(new String(""))) {
                try {
                    this.CalendarStart = Calendar.getInstance();
                    this.CalendarEnd = Calendar.getInstance();
                    this.CalendarStart.setTime(this.date_formater.parse(this.DateStart));
                    this.CalendarEnd.setTime(this.date_formater.parse(this.DateEnd));
                }
                catch (ParseException ex) {
                    log.error("YahooFinanceInputSynapse could not parse date string. Message is : = " + ex.getMessage());
                    this.CalendarStart = null;
                    this.CalendarEnd = null;
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "YahooFinanceInputSynapse could not parse date string. " + ex.getMessage());
                    }
                    return;
                }
                int addedData = 1;
                if (this.CalendarStart != null && this.CalendarEnd != null && this.Period != null) {
                    log.info("Contacting Yahoo Finance Network.");
                    try {
                        while (addedData > 0 && addedData <= 200) {
                            myUrl = new String("http://table.finance.yahoo.com/table.csv?a=" + this.CalendarStart.get(2) + "&b=" + this.CalendarStart.get(5) + "&c=" + this.CalendarStart.get(1) + "&d=" + this.CalendarEnd.get(2) + "&e=" + this.CalendarEnd.get(5) + "&f=" + this.CalendarEnd.get(1) + "&s=" + this.Symbol + "&g=" + cperiod + "&z=200&y=" + start + "&ignore=.csv");
                            addedData = this.AddURLToMemory(new URL(myUrl));
                            start += 200;
                        }
                    }
                    catch (IOException ex) {
                        log.error("Error obtaining data from YahooFInance. Error message is " + ex.getMessage());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Error obtaining data from YahooFInance." + ex.getMessage());
                        }
                        return;
                    }
                    log.info("Loaded Yahoo Fianance data ok.");
                    for (int i = this.StockData[0].size() - 1; i >= 0; --i) {
                        final_patterns = final_patterns + ((Double)this.StockData[0].elementAt(i)).toString();
                        final_patterns = final_patterns + ";" + ((Double)this.StockData[1].elementAt(i)).toString();
                        final_patterns = final_patterns + ";" + ((Double)this.StockData[2].elementAt(i)).toString();
                        final_patterns = final_patterns + ";" + ((Double)this.StockData[3].elementAt(i)).toString();
                        final_patterns = final_patterns + ";" + ((Double)this.StockData[4].elementAt(i)).toString();
                        final_patterns = final_patterns + ";" + ((Double)this.StockData[5].elementAt(i)).toString();
                        final_patterns = final_patterns + '\n';
                    }
                    try {
                        StreamInputTokenizer sit = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new StringReader(final_patterns), this.getMaxBufSize()) : new StreamInputTokenizer(new StringReader(final_patterns));
                        super.setTokens(sit);
                    }
                    catch (IOException ex) {
                        log.error("IOException thrown while initializing the YahooFinanceInputStream. Message is : " + ex.getMessage());
                        if (this.getMonitor() == null) break block13;
                        new NetErrorManager(this.getMonitor(), "Error while trying to parse Yahoo Finance data. Message is : " + ex.getMessage());
                    }
                }
            }
        }
    }

    private int AddURLToMemory(URL Data) throws IOException {
        LineNumberReader url_reader = null;
        String Line = new String("");
        String convLine = new String("");
        String tmp_string = new String("");
        boolean IgnoreHeader = true;
        boolean added_data = true;
        boolean Docontinue = true;
        log.debug(Data.getProtocol() + "://" + Data.getHost() + Data.getFile());
        int initSize = 0;
        if (Data != null) {
            url_reader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(Data.openStream())));
            Line = url_reader.readLine();
            if (this.StockDates == null) {
                this.StockDates = new Vector();
            }
            if (this.StockData == null || this.StockData.length < 6) {
                this.StockData = new Vector[6];
            }
            if (this.StockData[0] == null) {
                this.StockData[0] = new Vector();
            }
            if (this.StockData[1] == null) {
                this.StockData[1] = new Vector();
            }
            if (this.StockData[2] == null) {
                this.StockData[2] = new Vector();
            }
            if (this.StockData[3] == null) {
                this.StockData[3] = new Vector();
            }
            if (this.StockData[4] == null) {
                this.StockData[4] = new Vector();
            }
            if (this.StockData[5] == null) {
                this.StockData[5] = new Vector();
            }
            initSize = this.StockData[0].size();
            while (Line != null && !Line.equals("") && Docontinue) {
                if (IgnoreHeader && Line.indexOf(this.ColumnNames[0]) < 0) {
                    if (Line.indexOf(",") != -1) {
                        StringTokenizer tokens = new StringTokenizer(Line, ",\n");
                        if (tokens.countTokens() >= 7) {
                            added_data = true;
                            String _data = tokens.nextToken();
                            this.StockDates.addElement(_data);
                            this.StockData[0].add(Double.valueOf(tokens.nextToken()));
                            this.StockData[1].add(Double.valueOf(tokens.nextToken()));
                            this.StockData[2].add(Double.valueOf(tokens.nextToken()));
                            this.StockData[3].add(Double.valueOf(tokens.nextToken()));
                            this.StockData[4].add(Double.valueOf(tokens.nextToken()));
                            this.StockData[5].add(Double.valueOf(tokens.nextToken()));
                        }
                    } else {
                        Docontinue = false;
                    }
                }
                Line = url_reader.readLine();
            }
        }
        int addedData = this.StockData[0].size() - initSize;
        return addedData;
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getDateStart() != null && !this.getDateStart().equals("")) {
            try {
                this.date_formater.parse(this.DateStart);
            }
            catch (ParseException ex) {
                checks.add(new NetCheck(0, "Format for Start Date is invalid.", this));
            }
        } else {
            checks.add(new NetCheck(0, "Start Date should be populated.", this));
        }
        if (this.getDateEnd() != null && !this.getDateEnd().equals("")) {
            try {
                this.date_formater.parse(this.DateEnd);
            }
            catch (ParseException ex) {
                checks.add(new NetCheck(0, "Format for End Date is invalid.", this));
            }
        } else {
            checks.add(new NetCheck(0, "End Date should be populated.", this));
        }
        if (this.getPeriod() != null) {
            if (!(this.getPeriod().equals("Daily") || this.getPeriod().equals("Weekly") || this.getPeriod().equals("Monthly"))) {
                checks.add(new NetCheck(0, "Period should be one of 'Daily' , 'Weekly' , 'Monthly'.", this));
            }
        } else {
            checks.add(new NetCheck(0, "Period should be one of 'Daily' , 'Weekly' , 'Monthly'.", this));
        }
        if (this.getSymbol() == null || this.getSymbol().equals("")) {
            checks.add(new NetCheck(0, "Symbol should be populated.", this));
        }
        return checks;
    }
}

