/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.InputsInspection;
import org.joone.io.InputConnector;
import org.joone.io.InputSynapse;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.CSVParser;
import org.joone.util.ConverterPlugIn;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class StreamInputSynapse
extends Synapse
implements InputSynapse,
Inspectable {
    private static final ILogger log = LoggerFactory.getLogger(StreamInputSynapse.class);
    private int firstRow = 1;
    private int lastRow = 0;
    private int firstCol = 0;
    private int lastCol = 0;
    private String advColumnsSel = "";
    private boolean buffered = true;
    private char decimalPoint = (char)46;
    private boolean StepCounter = true;
    protected transient int[] cols;
    protected transient Vector InputVector;
    protected transient int currentRow = 0;
    protected transient PatternTokenizer tokens;
    protected transient boolean EOF = false;
    private Vector toInputVector;
    private ConverterPlugIn plugIn;
    private int maxBufSize = 0;
    private static final long serialVersionUID = -3316265583083866079L;
    private transient int startFrom = 0;
    List plugInListeners = new ArrayList();
    private int myFirstRow = 1;
    private int myLastRow = 0;
    private transient boolean skipNewCycle = false;

    protected void backward(double[] pattern) {
    }

    protected void forward(double[] pattern) {
        this.outs = pattern;
    }

    public synchronized Pattern fwdGet() {
        boolean cont;
        if (!this.isEnabled()) {
            return null;
        }
        if (this.EOF || this.outs == null) {
            try {
                if (this.EOF && this.getMonitor() != null && this.isStepCounter()) {
                    this.getMonitor().resetCycle();
                }
                this.gotoFirstLine();
                this.outs = new double[1];
            }
            catch (Exception ioe) {
                log.error("Exception while executing the \"fwdGet\". Message is : " + ioe.getMessage());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "Exception while executing the \"fwdGet\" method. Message is : " + ioe.getMessage());
                }
                return this.zeroPattern();
            }
        }
        if (this.currentRow - this.firstRow > this.getMonitor().getNumOfPatterns() - 1) {
            try {
                this.gotoFirstLine();
            }
            catch (Exception ioe) {
                log.error("Exception while executing the \"fwdGet\". Message is : " + ioe.getMessage());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "Exception while attempting to access the first line. Message is : " + ioe.getMessage());
                }
                return this.zeroPattern();
            }
        }
        if (this.isStepCounter() && !(cont = this.getMonitor().nextStep())) {
            this.reset();
            return this.zeroPattern();
        }
        if (this.isBuffered()) {
            int actualRow = this.currentRow - this.firstRow + (this.startFrom == 0 ? 0 : this.startFrom - 1);
            if (this.getInputVector().size() == 0) {
                this.readAll();
            } else if (this.currentRow == this.firstRow && this.getPlugIn() != null && !this.skipNewCycle) {
                this.getPlugIn().setInputVector(this.getInputVector());
                if (this.getPlugIn().newCycle()) {
                    this.fireDataChanged();
                }
            }
            if (actualRow < this.InputVector.size()) {
                this.m_pattern = (Pattern)this.InputVector.elementAt(actualRow);
            }
            if (this.lastRow > 0 && this.currentRow >= this.lastRow) {
                this.EOF = true;
            }
            if (actualRow + 1 >= this.InputVector.size()) {
                this.EOF = true;
            }
            ++this.currentRow;
        } else {
            try {
                this.m_pattern = this.getStream();
            }
            catch (Exception ioe) {
                String error = "Exception in " + this.getName() + ". Message is : ";
                log.error(error + ioe.getMessage());
                ioe.printStackTrace();
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
                }
                return this.zeroPattern();
            }
        }
        this.m_pattern.setCount(this.currentRow - this.firstRow);
        return this.m_pattern;
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    protected Vector getInputVector() {
        if (this.InputVector == null) {
            this.InputVector = new Vector();
        }
        return this.InputVector;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    protected Pattern getStream() throws IOException {
        int x = 0;
        boolean bl = this.EOF = !this.tokens.nextLine();
        if (!this.EOF) {
            if (this.cols == null) {
                this.setColList();
            }
            if (this.cols == null) {
                return null;
            }
            this.inps = new double[this.cols.length];
            for (x = 0; x < this.cols.length; ++x) {
                this.inps[x] = this.tokens.getTokenAt(this.cols[x] - 1);
            }
            ++this.currentRow;
            if (this.lastRow > 0 && this.currentRow > this.lastRow) {
                this.EOF = true;
            }
            this.forward(this.inps);
            this.m_pattern = new Pattern(this.outs);
            this.m_pattern.setCount(this.currentRow - this.firstRow);
            return this.m_pattern;
        }
        return null;
    }

    public void gotoFirstLine() throws IOException {
        this.gotoLine(this.firstRow);
    }

    public void gotoLine(int numLine) throws IOException {
        PatternTokenizer tk;
        this.EOF = false;
        if (!(this.isBuffered() && this.getInputVector().size() != 0 || (tk = this.getTokens()) == null)) {
            if (this.isBuffered()) {
                tk.resetInput();
            } else {
                this.initInputStream();
            }
            this.EOF = false;
            this.currentRow = 1;
            while (this.currentRow < numLine && !this.EOF) {
                if (this.tokens.nextLine()) {
                    ++this.currentRow;
                    continue;
                }
                this.EOF = true;
            }
        }
        this.currentRow = numLine;
        this.EOF = this.lastRow > 0 && this.currentRow >= this.lastRow;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public boolean isEOF() {
        return this.EOF;
    }

    public boolean isStepCounter() {
        return this.StepCounter;
    }

    public int numColumns() {
        if (this.cols == null) {
            this.setColList();
        }
        if (this.cols == null) {
            return 0;
        }
        return this.cols.length;
    }

    public void readAll() {
        block6: {
            this.getInputVector().removeAllElements();
            try {
                this.gotoFirstLine();
                Pattern ptn = this.getStream();
                while (ptn != null) {
                    this.InputVector.addElement(ptn);
                    if (this.EOF) break;
                    ptn = this.getStream();
                }
                if (this.plugIn != null) {
                    this.plugIn.setInputVector(this.InputVector);
                    this.plugIn.convertPatterns();
                }
                this.gotoFirstLine();
            }
            catch (IOException ioe) {
                String error = "IOException in " + this.getName() + ". Message is : ";
                log.warn(error + ioe.getMessage());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
                }
            }
            catch (NumberFormatException nfe) {
                String error = "IOException in " + this.getName() + ". Message is : ";
                log.warn(error + nfe.getMessage());
                if (this.getMonitor() == null) break block6;
                new NetErrorManager(this.getMonitor(), error + nfe.getMessage());
            }
        }
    }

    public synchronized void revPut(Pattern array) {
    }

    protected void setArrays(int rows, int cols) {
    }

    public void setBuffered(boolean aNewBuffered) {
        this.buffered = this.plugIn == null ? aNewBuffered : true;
    }

    protected void setColList() {
        boolean maxCol = false;
        if (this.getAdvancedColumnSelector().trim().length() > 0) {
            CSVParser parser = new CSVParser(this.getAdvancedColumnSelector().trim());
            try {
                this.cols = parser.parseInt();
            }
            catch (NumberFormatException nfe) {
                new NetErrorManager(this.getMonitor(), nfe.getMessage());
            }
        } else {
            if (this.getFirstCol() == 0 || this.getLastCol() == 0) {
                return;
            }
            this.cols = new int[this.getLastCol() - this.getFirstCol() + 1];
            for (int i = this.getFirstCol(); i <= this.getLastCol(); ++i) {
                this.cols[i - this.getFirstCol()] = i;
            }
        }
    }

    public void setDecimalPoint(char dp) {
        this.decimalPoint = dp;
        if (this.tokens != null) {
            this.tokens.setDecimalPoint(dp);
        }
    }

    protected void setDimensions(int rows, int cols) {
    }

    protected void setEOF(boolean newEOF) {
        this.EOF = newEOF;
    }

    public void setFirstRow(int newFirstRow) {
        this.myFirstRow = this.firstRow;
        if (this.firstRow != newFirstRow) {
            this.firstRow = newFirstRow;
            this.resetInput();
        }
    }

    public synchronized void resetInput() {
        this.restart();
        this.tokens = null;
        this.notifyAll();
    }

    private void restart() {
        this.getInputVector().removeAllElements();
        this.EOF = false;
        this.cols = null;
    }

    public void setLastRow(int newLastRow) {
        this.myLastRow = this.lastRow;
        if (this.lastRow != newLastRow) {
            this.lastRow = newLastRow;
            this.resetInput();
        }
    }

    public boolean addPlugIn(ConverterPlugIn aNewPlugIn) {
        if (this.plugIn == aNewPlugIn) {
            return false;
        }
        if (aNewPlugIn == null) {
            if (this.plugIn != null) {
                this.plugIn.setConnected(false);
            }
            this.plugIn = null;
            this.resetInput();
            return true;
        }
        if (aNewPlugIn.isConnected()) {
            return false;
        }
        if (this.plugIn == null) {
            aNewPlugIn.setConnected(true);
            aNewPlugIn.addPlugInListener(this);
            this.setBuffered(true);
            this.plugIn = aNewPlugIn;
            this.resetInput();
            return true;
        }
        return this.plugIn.addPlugIn(aNewPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.plugIn != null) {
            this.plugIn.setConnected(false);
            this.plugIn.removeAllPlugIns();
            this.plugIn = null;
        }
    }

    public boolean setPlugin(ConverterPlugIn newPlugIn) {
        if (newPlugIn == this.plugIn) {
            return false;
        }
        if (newPlugIn == null) {
            this.plugIn.setConnected(false);
        } else {
            if (newPlugIn.isConnected()) {
                return false;
            }
            newPlugIn.setConnected(true);
            newPlugIn.addPlugInListener(this);
            this.buffered = true;
        }
        this.plugIn = newPlugIn;
        this.resetInput();
        return true;
    }

    public ConverterPlugIn getPlugIn() {
        return this.plugIn;
    }

    public void setPlugIn(ConverterPlugIn newPlugIn) {
        this.setPlugin(newPlugIn);
    }

    public void setStepCounter(boolean newStepCounter) {
        this.StepCounter = newStepCounter;
    }

    protected void writeObjectBase(ObjectOutputStream out) throws IOException {
        int s = 0;
        if (this.isBuffered() && (s = this.getInputVector().size()) == 0 && this.tokens != null) {
            this.gotoFirstLine();
            this.readAll();
        }
        if (out.getClass().getName().indexOf("xstream") != -1) {
            this.toInputVector = this.isBuffered() ? this.InputVector : null;
            out.defaultWriteObject();
            this.toInputVector = null;
        } else {
            out.defaultWriteObject();
            if (this.isBuffered()) {
                s = this.getInputVector().size();
                out.writeInt(s);
                for (int i = 0; i < s; ++i) {
                    out.writeObject(this.InputVector.elementAt(i));
                }
            }
        }
    }

    protected void readObjectBase(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.getClass().getName().indexOf("xstream") != -1) {
            if (this.toInputVector != null) {
                this.InputVector = (Vector)this.toInputVector.clone();
                this.toInputVector = null;
            }
        } else if (this.isBuffered()) {
            this.getInputVector().removeAllElements();
            int s = in.readInt();
            for (int i = 0; i < s; ++i) {
                Pattern ptn = (Pattern)in.readObject();
                this.InputVector.addElement(ptn);
            }
        }
        if (this.advColumnsSel == null) {
            this.advColumnsSel = "";
        }
        if (this.plugInListeners == null) {
            this.plugInListeners = new ArrayList();
        }
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(int lastCol) throws IllegalArgumentException {
        if (this.lastCol != lastCol) {
            this.lastCol = lastCol;
            this.cols = null;
        }
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(int firstCol) throws IllegalArgumentException {
        if (this.firstCol != firstCol) {
            this.firstCol = firstCol;
            this.cols = null;
        }
    }

    public String getAdvancedColumnSelector() {
        return this.advColumnsSel;
    }

    public void setAdvancedColumnSelector(String newAdvColSel) {
        if (this.advColumnsSel.compareTo(newAdvColSel) != 0) {
            this.advColumnsSel = newAdvColSel;
            this.resetInput();
        }
    }

    public void dataChanged(PlugInEvent data) {
        this.resetInput();
    }

    protected PatternTokenizer getTokens() throws JooneRuntimeException {
        if (this.tokens == null) {
            this.initInputStream();
        }
        return this.tokens;
    }

    protected void setTokens(PatternTokenizer tkn) {
        this.tokens = tkn;
        if (this.tokens != null) {
            this.tokens.setDecimalPoint(this.getDecimalPoint());
        }
        this.restart();
    }

    protected Pattern zeroPattern() {
        Pattern pat = new Pattern(new double[this.getOutputDimension()]);
        pat.setCount(-1);
        return pat;
    }

    protected abstract void initInputStream() throws JooneRuntimeException;

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.firstRow <= 0) {
            checks.add(new NetCheck(0, "First Row parameter cannot be less than 1.", this));
        }
        if (this.advColumnsSel == null) {
            if (this.firstCol <= 0 || this.lastCol <= 0) {
                checks.add(new NetCheck(0, "Input columns not set.", this));
            } else if (this.advColumnsSel.trim().length() == 0) {
                checks.add(new NetCheck(0, "Input columns not set.", this));
            }
        }
        if (this.isBuffered() && this.getInputVector().size() == 0) {
            try {
                this.getTokens();
            }
            catch (JooneRuntimeException jre) {
                checks.add(new NetCheck(0, "Cannot initialize the input stream: " + jre.getMessage(), this));
            }
        }
        if (this.getPlugIn() != null) {
            this.getPlugIn().check(checks);
        }
        return checks;
    }

    public Collection Inspections() {
        ArrayList<InputsInspection> col = new ArrayList<InputsInspection>();
        if (this.isBuffered()) {
            if (this.getInputVector().size() == 0 && this.getTokens() != null) {
                this.readAll();
            }
            col.add(new InputsInspection(this.getInputVector()));
        } else {
            col.add(new InputsInspection(null));
        }
        return col;
    }

    public String InspectableTitle() {
        return this.getName();
    }

    public void reset() {
        super.reset();
        this.outs = null;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int maxBufSize) {
        this.maxBufSize = maxBufSize;
    }

    public Vector getInputPatterns() {
        return this.InputVector;
    }

    public void setInputPatterns(Vector inputPatterns) {
        this.InputVector = inputPatterns;
    }

    public synchronized Pattern fwdGet(InputConnector conn) {
        if (this.isBuffered() && this.getInputVector().size() == 0) {
            this.firstRow = this.myFirstRow;
            this.lastRow = this.myLastRow;
            this.startFrom = 0;
            this.skipNewCycle = false;
            this.readAll();
        }
        if (conn == null) {
            return null;
        }
        this.skipNewCycle = !conn.isStepCounter();
        this.firstRow = conn.getFirstRow();
        this.lastRow = conn.getLastRow();
        this.EOF = conn.isEOF();
        this.currentRow = conn.getCurrentRow();
        this.startFrom = this.firstRow;
        Pattern retValue = this.fwdGet();
        this.firstRow = this.myFirstRow;
        this.lastRow = this.myLastRow;
        this.startFrom = 0;
        return retValue;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public void addPlugInListener(PlugInListener aListener) {
        if (!this.plugInListeners.contains(aListener)) {
            this.plugInListeners.add(aListener);
        }
    }

    public void removePlugInListener(PlugInListener aListener) {
        this.plugInListeners.remove(aListener);
    }

    public List getAllPlugInListeners() {
        return this.plugInListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        Object[] myList;
        StreamInputSynapse streamInputSynapse = this;
        synchronized (streamInputSynapse) {
            myList = this.getAllPlugInListeners().toArray();
        }
        for (int i = 0; i < myList.length; ++i) {
            if (myList[i] == null) continue;
            ((PlugInListener)myList[i]).dataChanged(new PlugInEvent(this));
        }
    }
}

