/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import org.joone.io.PatternTokenizer;

public class MemoryInputTokenizer
implements PatternTokenizer {
    private double[][] inputArray;
    private int lineNo = 0;
    private int mark = 0;
    private char decimalPoint;

    public MemoryInputTokenizer() {
    }

    public MemoryInputTokenizer(double[][] array) {
        this.inputArray = array;
    }

    public void resetInput() throws IOException {
        this.lineNo = this.mark;
    }

    public int getLineno() {
        return this.lineNo;
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public boolean nextLine() throws IOException {
        ++this.lineNo;
        return this.lineNo <= this.inputArray.length;
    }

    public int getNumTokens() throws IOException {
        double[] line = this.getTokensArray();
        return line.length;
    }

    public void mark() throws IOException {
        this.mark = this.lineNo;
    }

    public double getTokenAt(int posiz) throws IOException {
        double[] line = this.getTokensArray();
        return line[posiz];
    }

    public double[] getTokensArray() {
        return this.inputArray[this.lineNo - 1];
    }

    public void setDecimalPoint(char decimalPoint) {
        this.decimalPoint = decimalPoint;
    }
}

