/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class JDBCInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(JDBCInputSynapse.class);
    private String driverName = "";
    private String dbURL = "";
    private String SQLQuery = "";
    private static final long serialVersionUID = -4642657913289986240L;

    public JDBCInputSynapse() {
    }

    public JDBCInputSynapse(String newDrivername, String newdbURL, String newSQLQuery, String newAdvColSel, int newfirstRow, int newlastRow, boolean buffered) {
        this.setBuffered(buffered);
        this.setFirstRow(newfirstRow);
        this.setLastRow(newlastRow);
        this.setAdvancedColumnSelector(newAdvColSel);
        this.setdriverName(newDrivername);
        this.setdbURL(newdbURL);
        this.setSQLQuery(newSQLQuery);
    }

    public String getdriverName() {
        return this.driverName;
    }

    public String getdbURL() {
        return this.dbURL;
    }

    public String getSQLQuery() {
        return this.SQLQuery;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObjectBase(in);
        if (in.getClass().getName().indexOf("xstream") == -1) {
            this.driverName = (String)in.readObject();
            this.dbURL = (String)in.readObject();
            this.SQLQuery = (String)in.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setdriverName(this.driverName);
        }
    }

    public void setdriverName(String newDriverName) {
        if (!newDriverName.equals(this.driverName)) {
            this.driverName = newDriverName;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setdbURL(String newdbURL) {
        if (!this.dbURL.equals(newdbURL)) {
            this.dbURL = newdbURL;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setSQLQuery(String newSQLQuery) {
        if (!this.SQLQuery.equals(newSQLQuery)) {
            this.SQLQuery = newSQLQuery;
            this.resetInput();
            this.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObjectBase(out);
        if (out.getClass().getName().indexOf("xstream") == -1) {
            out.writeObject(this.driverName);
            out.writeObject(this.dbURL);
            out.writeObject(this.SQLQuery);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        block18: {
            if (this.driverName != null && !this.driverName.equals(new String(""))) {
                if (this.dbURL != null && !this.dbURL.equals(new String(""))) {
                    if (this.SQLQuery != null && !this.SQLQuery.equals(new String(""))) {
                        try {
                            Class.forName(this.driverName);
                            Connection con = DriverManager.getConnection(this.dbURL);
                            Statement stmt = con.createStatement();
                            ResultSet rs = stmt.executeQuery(this.SQLQuery);
                            StringBuffer SQLNetInput = new StringBuffer();
                            while (rs.next()) {
                                if (rs.getMetaData().getColumnCount() >= 1) {
                                    SQLNetInput.append(rs.getDouble(1));
                                }
                                for (int counter = 2; counter <= rs.getMetaData().getColumnCount(); ++counter) {
                                    SQLNetInput.append(";");
                                    SQLNetInput.append(rs.getDouble(counter));
                                }
                                SQLNetInput.append('\n');
                            }
                            StreamInputTokenizer sit = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new StringReader(SQLNetInput.toString()), this.getMaxBufSize()) : new StreamInputTokenizer(new StringReader(SQLNetInput.toString()));
                            super.setTokens(sit);
                        }
                        catch (ClassNotFoundException ex) {
                            log.error("Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + ex.getMessage(), ex);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + ex.getMessage());
                            }
                            break block18;
                        }
                        catch (SQLException sqlex) {
                            log.error("SQLException thrown while initializing the JDBCInputStream. Message is : " + sqlex.getMessage(), sqlex);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "SQLException thrown while initializing the JDBCInputStream. Message is : " + sqlex.getMessage());
                            }
                            break block18;
                        }
                        catch (IOException ex) {
                            log.error("IOException thrown while initializing the JDBCInputStream. Message is : " + ex.getMessage(), ex);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "IOException thrown while initializing the JDBCInputStream. Message is : " + ex.getMessage());
                            }
                            break block18;
                        }
                    }
                    String err = "The SQL Query has not been entered!";
                    log.warn(err);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The SQL Query has not been entered!");
                    }
                } else {
                    String err = "The Database URL has not been entered!";
                    log.warn(err);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The Database URL has not been entered!");
                    }
                }
            } else {
                String err = "The Driver Name has not been entered!";
                log.warn(err);
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "The Driver Name has not been entered!");
                }
            }
        }
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.driverName == null || this.driverName.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database Driver Name needs to be entered.", this));
        } else {
            try {
                Class.forName(this.driverName);
                if (this.dbURL != null && this.dbURL.compareTo("") != 0) {
                    Connection connection = DriverManager.getConnection(this.dbURL);
                }
            }
            catch (ClassNotFoundException ex) {
                checks.add(new NetCheck(0, "Could not find Database Driver Class. Check Database Driver is in the classpath and is readable.", this));
            }
            catch (SQLException sqlex) {
                checks.add(new NetCheck(0, "The Database URL is incorrect. Connection error is : " + sqlex.toString(), this));
            }
        }
        if (this.dbURL == null || this.dbURL.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database URL needs to be entered.", this));
        }
        if (this.SQLQuery == null || this.SQLQuery.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database SQL Query needs to be entered.", this));
        }
        return checks;
    }
}

