/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.util.TreeSet;
import org.joone.engine.Monitor;
import org.joone.engine.Pattern;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public class InputConnector
extends StreamInputSynapse
implements PlugInListener {
    private static final ILogger log = LoggerFactory.getLogger(InputConnector.class);
    private static final long serialVersionUID = -3316265583123866079L;
    private StreamInputSynapse inputSynapse;

    public InputConnector() {
        this.setBuffered(false);
    }

    protected void initInputStream() throws JooneRuntimeException {
        this.currentRow = this.getFirstRow();
        this.EOF = false;
    }

    public void setInputSynapse(StreamInputSynapse input) {
        if (input != null) {
            input.setMonitor(this.getMonitor());
            input.setBuffered(true);
            input.setStepCounter(false);
            input.setInputFull(true);
            input.addPlugInListener(this);
            this.setOutputFull(true);
        } else {
            this.setOutputFull(false);
            if (this.inputSynapse != null) {
                this.inputSynapse.removePlugInListener(this);
                this.inputSynapse.setInputFull(false);
            }
        }
        this.inputSynapse = input;
    }

    protected Pattern getStream() {
        if (this.inputSynapse == null) {
            return null;
        }
        Pattern patt = this.inputSynapse.fwdGet(this);
        if (patt != null) {
            if (this.cols == null) {
                this.setColList();
            }
            if (this.cols == null) {
                return null;
            }
            this.inps = new double[this.cols.length];
            for (int x = 0; x < this.cols.length; ++x) {
                this.inps[x] = patt.getArray()[this.cols[x] - 1];
            }
            ++this.currentRow;
            if (this.currentRow - this.getFirstRow() > this.getMonitor().getNumOfPatterns() - 1) {
                this.EOF = true;
            }
            if (this.getLastRow() > 0 && this.getCurrentRow() > this.getLastRow()) {
                this.EOF = true;
            }
            this.forward(this.inps);
            Pattern newPattern = new Pattern(this.outs);
            newPattern.setCount(this.getCurrentRow() - this.getFirstRow());
            return newPattern;
        }
        return null;
    }

    public void setMonitor(Monitor newMonitor) {
        super.setMonitor(newMonitor);
        if (this.inputSynapse != null) {
            this.inputSynapse.setMonitor(newMonitor);
        }
    }

    public void dataChanged(PlugInEvent anEvent) {
        this.getInputVector().removeAllElements();
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.inputSynapse == null) {
            checks.add(new NetCheck(0, "Input Synapse not set", this));
        } else if (!this.inputSynapse.isBuffered()) {
            checks.add(new NetCheck(0, "The Input Synapse must be buffered", this));
        }
        return checks;
    }

    public void resetInput() {
        if (this.inputSynapse != null) {
            this.inputSynapse.resetInput();
        }
    }
}

