/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class TanhLayer
extends SimpleLayer
implements LearnableLayer {
    private static final long serialVersionUID = -2073914754873517298L;
    private static final ILogger log = LoggerFactory.getLogger(TanhLayer.class);

    public TanhLayer() {
        this.learnable = true;
    }

    public TanhLayer(String name) {
        this();
        this.setLayerName(name);
    }

    public void backward(double[] pattern) {
        super.backward(pattern);
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            this.gradientOuts[x] = pattern[x] * (1.0 + this.outs[x]) * (1.0 - this.outs[x]);
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] pattern) {
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            this.outs[x] = -1.0 + 2.0 / (1.0 + Math.exp(-2.0 * (pattern[x] + this.bias.value[x][0])));
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

